% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_project.R
\name{make_project}
\alias{make_project}
\title{Make an Analysis Project}
\usage{
make_project(path)
}
\arguments{
\item{path}{Path automatically set by research_project.dcf (see
\code{./rstudio/templates/project/})}
}
\value{
Creates a project directory with the following contents: a template
   \code{.Rmd} file called "analysis", a subdirectory for data, a template
   \code{.gitignore} with aggressive protections against publishing potential
   protected health information, a starter bibliography file called 
   "references" (in standard \code{.bib} format), and a stock Citation Style
   Language (\code{.csl}) file for the New England Journal of Medicine.
}
\description{
This function makes an R project that includes an analysis.Rmd 
file with conflicted and tidyverse and an aggressive .gitignore.  The 
.gitignore is designed to help protect against leaking data (with protected 
health information). This function is used by the research_project.dcf file 
to make the files.
}
\examples{
\dontrun{
  make_project(path = "~/test_project")
}
}
