% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wind_functions2.R
\name{wind.mean}
\alias{wind.mean}
\title{Wind-data mean}
\usage{
wind.mean(x)
}
\arguments{
\item{x}{An object of class \code{rWind_series}}
}
\value{
An object of class \code{rWind}, which is a \code{data.frame}
}
\description{
wind.mean computes the mean (average) wind speed and wind direction of a time
series dataset of winds of the same region.
Summaries of time series are not trivial to compute. We compute the
arithmetic mean for the wind speed.
The direction as the circular mean, see
\url{https://en.wikipedia.org/wiki/Mean_of_circular_quantities}
for more details. The U and V componenats are afterwards transformed from
these values.
}
\note{
For large time series, it could take a while.
}
\examples{
data(wind.series)
wind_average<- wind.mean(wind.series)


}
\references{
https://en.wikipedia.org/wiki/Cross_product
}
\seealso{
\code{\link{wind.dl}}
}
\author{
Javier Fernández-López (jflopez@rjb.csic.es)
}
\keyword{~kwd1}
\keyword{~kwd2}
