% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivotr.R
\name{pivotr}
\alias{pivotr}
\title{Create a pivot table}
\usage{
pivotr(
  dataset,
  cvars = "",
  nvar = "None",
  fun = "mean",
  normalize = "None",
  tabfilt = "",
  tabsort = "",
  nr = Inf,
  data_filter = "",
  envir = parent.frame()
)
}
\arguments{
\item{dataset}{Dataset to tabulate}

\item{cvars}{Categorical variables}

\item{nvar}{Numerical variable}

\item{fun}{Function to apply to numerical variable}

\item{normalize}{Normalize the table by row total, column totals, or overall total}

\item{tabfilt}{Expression used to filter the table (e.g., "Total > 10000")}

\item{tabsort}{Expression used to sort the table (e.g., "desc(Total)")}

\item{nr}{Number of rows to display}

\item{data_filter}{Expression used to filter the dataset before creating the table (e.g., "price > 10000")}

\item{envir}{Environment to extract data from}
}
\description{
Create a pivot table
}
\details{
Create a pivot-table. See \url{https://radiant-rstats.github.io/docs/data/pivotr.html} for an example in Radiant
}
\examples{
pivotr(diamonds, cvars = "cut") \%>\% str()
pivotr(diamonds, cvars = "cut")$tab
pivotr(diamonds, cvars = c("cut","clarity","color"))$tab
pivotr(diamonds, cvars = "cut:clarity", nvar = "price")$tab
pivotr(diamonds, cvars = "cut", nvar = "price")$tab
pivotr(diamonds, cvars = "cut", normalize = "total")$tab

}
