% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomizer.R
\name{randomizer}
\alias{randomizer}
\title{Randomize cases into experimental conditions}
\usage{
randomizer(
  dataset,
  vars,
  conditions = c("A", "B"),
  blocks = NULL,
  probs = NULL,
  label = ".conditions",
  seed = 1234,
  data_filter = "",
  na.rm = FALSE,
  envir = parent.frame()
)
}
\arguments{
\item{dataset}{Dataset to sample from}

\item{vars}{The variables to sample}

\item{conditions}{Conditions to assign to}

\item{blocks}{A vector to use for blocking or a data.frame from which to construct a blocking vector}

\item{probs}{A vector of assignment probabilities for each treatment conditions. By default each condition is assigned with equal probability}

\item{label}{Name to use for the generated condition variable}

\item{seed}{Random seed to use as the starting point}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{na.rm}{Remove rows with missing values (FALSE or TRUE)}

\item{envir}{Environment to extract data from}
}
\value{
A list of variables defined in randomizer as an object of class randomizer
}
\description{
Randomize cases into experimental conditions
}
\details{
Wrapper for the complete_ra and block_ra from the randomizr package. See \url{https://radiant-rstats.github.io/docs/design/randomizer.html} for an example in Radiant
}
\examples{
randomizer(rndnames, "Names", conditions = c("test", "control")) \%>\% str()

}
\seealso{
\code{\link{summary.sampling}} to summarize results
}
