/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.distribution;

import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.distribution.Distribution;
import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.exponentialfamily.EF_BaseDistribution_MultinomialParents;
import eu.amidst.core.exponentialfamily.EF_Distribution;
import eu.amidst.core.utils.MultinomialIndex;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.StateSpaceTypeEnum;
import eu.amidst.core.variables.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class BaseDistribution_MultinomialParents<E extends Distribution>
extends ConditionalDistribution {
    private List<Variable> multinomialParents;
    private List<Variable> nonMultinomialParents;
    private List<E> baseDistributions;
    private boolean isBaseConditionalDistribution;

    public BaseDistribution_MultinomialParents(List<Variable> multinomialParents1, List<E> distributions1) {
        if (distributions1.size() == 0) {
            throw new IllegalArgumentException("Size of base distributions is zero");
        }
        int size = MultinomialIndex.getNumberOfPossibleAssignments(multinomialParents1);
        if (size != distributions1.size()) {
            throw new IllegalArgumentException("Size of base distributions list does not match with the number of parents configurations");
        }
        this.var = ((Distribution)distributions1.get(0)).getVariable();
        this.parents = new ArrayList();
        this.multinomialParents = multinomialParents1;
        this.nonMultinomialParents = new ArrayList<Variable>();
        this.baseDistributions = distributions1;
        if (!(this.baseDistributions.get(0) instanceof UnivariateDistribution)) {
            this.isBaseConditionalDistribution = true;
            for (int i = 0; i < size; ++i) {
                for (Variable v : this.getBaseConditionalDistribution(i).getConditioningVariables()) {
                    if (this.nonMultinomialParents.contains(v)) continue;
                    this.nonMultinomialParents.add(v);
                }
            }
        } else {
            this.isBaseConditionalDistribution = false;
        }
        this.parents.addAll(this.multinomialParents);
        this.parents.addAll(this.nonMultinomialParents);
    }

    public BaseDistribution_MultinomialParents(Variable var_, List<Variable> parents_) {
        this.var = var_;
        this.multinomialParents = new ArrayList<Variable>();
        this.nonMultinomialParents = new ArrayList<Variable>();
        this.parents = parents_;
        for (Variable parent : this.parents) {
            if (parent.getStateSpaceTypeEnum() == StateSpaceTypeEnum.FINITE_SET) {
                this.multinomialParents.add(parent);
                continue;
            }
            this.nonMultinomialParents.add(parent);
        }
        int size = MultinomialIndex.getNumberOfPossibleAssignments(this.multinomialParents);
        this.baseDistributions = new ArrayList(size);
        if (this.nonMultinomialParents.size() == 0) {
            this.isBaseConditionalDistribution = false;
            for (int i = 0; i < size; ++i) {
                this.baseDistributions.add(this.var.newUnivariateDistribution());
            }
        } else {
            this.isBaseConditionalDistribution = true;
            for (int i = 0; i < size; ++i) {
                this.baseDistributions.add(this.var.newConditionalDistribution(this.nonMultinomialParents));
            }
        }
    }

    public List<Variable> getMultinomialParents() {
        return this.multinomialParents;
    }

    public List<Variable> getNonMultinomialParents() {
        return this.nonMultinomialParents;
    }

    public boolean isBaseConditionalDistribution() {
        return this.isBaseConditionalDistribution;
    }

    public int getNumberOfBaseDistributions() {
        return this.baseDistributions.size();
    }

    public E getBaseDistribution(Assignment parentAssignment) {
        int position = MultinomialIndex.getIndexFromVariableAssignment(this.multinomialParents, parentAssignment);
        return (E)((Distribution)this.baseDistributions.get(position));
    }

    public void setBaseDistribution(Assignment parentAssignment, E baseDistribution) {
        int position = MultinomialIndex.getIndexFromVariableAssignment((List<Variable>)this.parents, parentAssignment);
        this.setBaseDistribution(position, baseDistribution);
    }

    public void setBaseDistribution(int position, E baseDistribution) {
        this.baseDistributions.set(position, baseDistribution);
    }

    public E getBaseDistribution(int position) {
        return (E)((Distribution)this.baseDistributions.get(position));
    }

    public List<E> getBaseDistributions() {
        return this.baseDistributions;
    }

    public ConditionalDistribution getBaseConditionalDistribution(int position) {
        return (ConditionalDistribution)this.getBaseDistribution(position);
    }

    public UnivariateDistribution getBaseUnivariateDistribution(int position) {
        return (UnivariateDistribution)this.getBaseDistribution(position);
    }

    @Override
    public void setConditioningVariables(List<Variable> parents) {
        this.parents = parents;
        this.multinomialParents = new ArrayList<Variable>();
        this.nonMultinomialParents = new ArrayList<Variable>();
        for (Variable parent : parents) {
            if (parent.getStateSpaceTypeEnum() == StateSpaceTypeEnum.FINITE_SET) {
                this.multinomialParents.add(parent);
                continue;
            }
            this.nonMultinomialParents.add(parent);
        }
        if (this.isBaseConditionalDistribution()) {
            for (int i = 0; i < this.getNumberOfBaseDistributions(); ++i) {
                this.getBaseConditionalDistribution(i).setConditioningVariables(this.nonMultinomialParents);
            }
        }
    }

    @Override
    public void setVar(Variable var) {
        this.var = var;
        for (Distribution baseDistribution : this.baseDistributions) {
            baseDistribution.setVar(var);
        }
    }

    @Override
    public double getLogConditionalProbability(Assignment assignment) {
        return ((Distribution)this.getBaseDistribution(assignment)).getLogProbability(assignment);
    }

    @Override
    public UnivariateDistribution getUnivariateDistribution(Assignment assignment) {
        if (this.isBaseConditionalDistribution) {
            return ((ConditionalDistribution)this.getBaseDistribution(assignment)).getUnivariateDistribution(assignment);
        }
        return (UnivariateDistribution)this.getBaseDistribution(assignment);
    }

    @Override
    public double[] getParameters() {
        double[] param = new double[this.getNumberOfParameters()];
        int count = 0;
        for (int i = 0; i < this.getNumberOfBaseDistributions(); ++i) {
            System.arraycopy(((Distribution)this.getBaseDistribution(i)).getParameters(), 0, param, count, ((Distribution)this.getBaseDistribution(i)).getNumberOfParameters());
            count += ((Distribution)this.getBaseDistribution(i)).getNumberOfParameters();
        }
        return param;
    }

    @Override
    public int getNumberOfParameters() {
        return this.baseDistributions.stream().mapToInt(dist -> dist.getNumberOfParameters()).sum();
    }

    @Override
    public String label() {
        if (this.getConditioningVariables().size() == 0 || this.multinomialParents.size() == 0) {
            return ((Distribution)this.getBaseDistribution(0)).label();
        }
        if (!this.isBaseConditionalDistribution) {
            return ((Distribution)this.getBaseDistribution(0)).label() + "| Multinomial";
        }
        return ((Distribution)this.getBaseDistribution(0)).label() + ", Multinomial";
    }

    @Override
    public void randomInitialization(Random random) {
        this.baseDistributions.stream().forEach(dist -> dist.randomInitialization(random));
    }

    @Override
    public boolean equalDist(Distribution dist, double threshold) {
        BaseDistribution_MultinomialParents newdist = (BaseDistribution_MultinomialParents)dist;
        int size = this.getNumberOfBaseDistributions();
        if (newdist.getNumberOfBaseDistributions() != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (((Distribution)this.getBaseDistribution(i)).equalDist((Distribution)newdist.getBaseDistribution(i), threshold)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("");
        for (int i = 0; i < this.getNumberOfBaseDistributions(); ++i) {
            str.append(((Distribution)this.getBaseDistribution(i)).toString());
            if (this.getNumberOfBaseDistributions() <= 1) continue;
            Assignment parentAssignment = MultinomialIndex.getVariableAssignmentFromIndex(this.getMultinomialParents(), i);
            str.append(" | " + parentAssignment.outputString());
            if (i >= this.getNumberOfBaseDistributions() - 1) continue;
            str.append("\n");
        }
        return str.toString();
    }

    public EF_BaseDistribution_MultinomialParents<? extends EF_Distribution> toEFConditionalDistribution() {
        if (this.isBaseConditionalDistribution()) {
            ArrayList base_ef_dists = new ArrayList();
            for (int i = 0; i < this.getNumberOfBaseDistributions(); ++i) {
                base_ef_dists.add(this.getBaseConditionalDistribution(i).toEFConditionalDistribution());
            }
            return new EF_BaseDistribution_MultinomialParents(this.multinomialParents, base_ef_dists);
        }
        ArrayList base_ef_dists = new ArrayList();
        for (int i = 0; i < this.getNumberOfBaseDistributions(); ++i) {
            base_ef_dists.add(this.getBaseUnivariateDistribution(i).toEFUnivariateDistribution());
        }
        return new EF_BaseDistribution_MultinomialParents(this.multinomialParents, base_ef_dists);
    }
}

