/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.io;

import eu.amidst.core.datastream.DataInstance;
import eu.amidst.core.datastream.DataOnMemory;
import eu.amidst.core.datastream.DataStream;
import eu.amidst.core.datastream.filereaders.DataFileReader;
import eu.amidst.core.datastream.filereaders.DataOnMemoryFromFile;
import eu.amidst.core.datastream.filereaders.DataStreamFromFile;
import eu.amidst.core.datastream.filereaders.arffFileReader.ARFFDataReader;
import java.lang.reflect.UndeclaredThrowableException;

public final class DataStreamLoader {
    private static String[] loaders = new String[]{"eu.amidst.core.datastream.filereaders.arffFileReader.ARFFDataReader", "eu.amidst.core.datastream.filereaders.arffFileReader.ARFFDataFolderReader"};
    private static DataFileReader dataFileReader = new ARFFDataReader();

    public static DataStream<DataInstance> open(String path) {
        dataFileReader = DataStreamLoader.selectRightLoader(path);
        dataFileReader.loadFromFile(path);
        return new DataStreamFromFile(dataFileReader);
    }

    public static DataOnMemory<DataInstance> loadDataOnMemoryFromFile(String path) {
        dataFileReader = DataStreamLoader.selectRightLoader(path);
        dataFileReader.loadFromFile(path);
        return new DataOnMemoryFromFile(dataFileReader);
    }

    private static DataFileReader selectRightLoader(String fileName) {
        try {
            for (String loaderName : loaders) {
                DataFileReader reader = (DataFileReader)Class.forName(loaderName).newInstance();
                if (!reader.doesItReadThisFile(fileName)) continue;
                return reader;
            }
        }
        catch (Exception ex) {
            throw new UndeclaredThrowableException(ex);
        }
        throw new IllegalArgumentException("The provided file name is not compatible with any of the available file readers");
    }
}

