/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.variables;

import eu.amidst.core.datastream.Attribute;
import eu.amidst.core.datastream.Attributes;
import eu.amidst.core.variables.DistributionType;
import eu.amidst.core.variables.DistributionTypeEnum;
import eu.amidst.core.variables.StateSpaceType;
import eu.amidst.core.variables.StateSpaceTypeEnum;
import eu.amidst.core.variables.Variable;
import eu.amidst.core.variables.VariableBuilder;
import eu.amidst.core.variables.distributionTypes.IndicatorType;
import eu.amidst.core.variables.stateSpaceTypes.FiniteStateSpace;
import eu.amidst.core.variables.stateSpaceTypes.RealStateSpace;
import eu.amidst.core.variables.stateSpaceTypes.SparseFiniteStateSpace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class Variables
implements Iterable<Variable>,
Serializable {
    private static final long serialVersionUID = 5077959998533923231L;
    private List<Variable> allVariables = new ArrayList<Variable>();
    private Map<String, Integer> mapping;

    public Variables() {
        this.mapping = new ConcurrentHashMap<String, Integer>();
    }

    public Variables(Attributes atts) {
        this.mapping = new ConcurrentHashMap<String, Integer>();
        for (Attribute att : atts.getListOfNonSpecialAttributes()) {
            VariableBuilder builder = new VariableBuilder(att);
            VariableImplementation var = new VariableImplementation(builder, this.allVariables.size());
            if (this.mapping.containsKey(var.getName())) {
                throw new IllegalArgumentException("Attribute list contains duplicated names");
            }
            this.mapping.put(var.getName(), var.getVarID());
            this.allVariables.add(var.getVarID(), var);
        }
    }

    public Variables(Attributes atts, HashMap<Attribute, DistributionTypeEnum> typeDists) {
        for (Attribute att : atts.getListOfNonSpecialAttributes()) {
            Variable var = typeDists.containsKey(att) ? this.newVariable(att, typeDists.get(att)) : this.newVariable(att);
            if (this.mapping.containsKey(var.getName())) {
                throw new IllegalArgumentException("Attribute list contains duplicated names");
            }
            this.mapping.put(var.getName(), var.getVarID());
            this.allVariables.add(var.getVarID(), var);
        }
    }

    public void setAttributes(Attributes attributes) {
        for (Attribute att : attributes.getListOfNonSpecialAttributes()) {
            Variable variable = this.getVariableByName(att.getName());
            VariableImplementation variableImplementation = (VariableImplementation)variable;
            variableImplementation.setAttribute(att);
        }
    }

    public Variable newMultinomialVariable(Attribute att) {
        return this.newVariable(att, DistributionTypeEnum.MULTINOMIAL);
    }

    public Variable newMultinomialVariable(String name, int nOfStates) {
        return this.newVariable(name, DistributionTypeEnum.MULTINOMIAL, new FiniteStateSpace(nOfStates));
    }

    public Variable newSparseMultionomialVariable(Attribute att) {
        if (((StateSpaceType)att.getStateSpaceType()).getStateSpaceTypeEnum() != StateSpaceTypeEnum.SPARSE_FINITE_SET) {
            throw new UnsupportedOperationException("A Sparse Multinomial can not be created from a non-sparse attribute");
        }
        return this.newVariable(att, DistributionTypeEnum.SPARSE_MULTINOMIAL);
    }

    public Variable newSparseMultionomialVariable(String name, int nOfStates) {
        return this.newVariable(name, DistributionTypeEnum.SPARSE_MULTINOMIAL, new SparseFiniteStateSpace(nOfStates));
    }

    public Variable newMultinomialVariable(String name, List<String> states) {
        return this.newVariable(name, DistributionTypeEnum.MULTINOMIAL, new FiniteStateSpace(states));
    }

    public Variable newMultinomialLogisticVariable(Attribute att) {
        return this.newVariable(att, DistributionTypeEnum.MULTINOMIAL_LOGISTIC);
    }

    public Variable newMultinomialLogisticVariable(String name, int nOfStates) {
        return this.newVariable(name, DistributionTypeEnum.MULTINOMIAL_LOGISTIC, new FiniteStateSpace(nOfStates));
    }

    public Variable newMultinomialLogisticVariable(String name, List<String> states) {
        return this.newVariable(name, DistributionTypeEnum.MULTINOMIAL_LOGISTIC, new FiniteStateSpace(states));
    }

    public Variable newGaussianVariable(Attribute att) {
        return this.newVariable(att, DistributionTypeEnum.NORMAL);
    }

    public Variable newGaussianVariable(String name) {
        return this.newVariable(name, DistributionTypeEnum.NORMAL, new RealStateSpace());
    }

    public Variable newTruncatedExponential(String name) {
        return this.newVariable(name, DistributionTypeEnum.TRUNCATED_EXPONENTIAL, new RealStateSpace(0.0, 1.0));
    }

    public Variable newIndicatorVariable(Variable var, double deltaValue) {
        VariableBuilder variableBuilder = new VariableBuilder();
        variableBuilder.setAttribute(var.getAttribute());
        variableBuilder.setDistributionType(DistributionTypeEnum.INDICATOR);
        String newVarName = var.getName() + "_INDICATOR";
        variableBuilder.setName(newVarName);
        variableBuilder.setObservable(true);
        variableBuilder.setStateSpaceType(new FiniteStateSpace(Arrays.asList("Zero", "NonZero")));
        VariableImplementation newVariable = new VariableImplementation(variableBuilder, this.getNumberOfVars());
        IndicatorType indicatorType = (IndicatorType)newVariable.getDistributionType();
        indicatorType.setDeltaValue(deltaValue);
        if (this.mapping.containsKey(newVarName)) {
            throw new IllegalArgumentException("Attribute list contains duplicated names");
        }
        this.mapping.put(newVarName, newVariable.getVarID());
        this.allVariables.add(newVariable);
        return newVariable;
    }

    public Variable newIndicatorVariable(Variable var, String deltaValueLabel) {
        VariableBuilder variableBuilder = new VariableBuilder();
        variableBuilder.setAttribute(var.getAttribute());
        variableBuilder.setDistributionType(DistributionTypeEnum.INDICATOR);
        String newVarName = var.getName() + "_INDICATOR";
        variableBuilder.setName(newVarName);
        variableBuilder.setObservable(true);
        variableBuilder.setStateSpaceType(new FiniteStateSpace(Arrays.asList("Zero", "NonZero")));
        VariableImplementation newVariable = new VariableImplementation(variableBuilder, this.getNumberOfVars());
        IndicatorType indicatorType = (IndicatorType)newVariable.getDistributionType();
        if (((StateSpaceType)var.getStateSpaceType()).getStateSpaceTypeEnum() != StateSpaceTypeEnum.FINITE_SET) {
            throw new UnsupportedOperationException("String labels can only be used for multinomial variables");
        }
        indicatorType.setDeltaValue(((FiniteStateSpace)var.getStateSpaceType()).getIndexOfState(deltaValueLabel));
        if (this.mapping.containsKey(newVarName)) {
            throw new IllegalArgumentException("Attribute list contains duplicated names");
        }
        this.mapping.put(newVarName, newVariable.getVarID());
        this.allVariables.add(newVariable);
        return newVariable;
    }

    public Variable newVariable(Attribute att, DistributionTypeEnum distributionTypeEnum) {
        VariableBuilder builder = new VariableBuilder(att);
        builder.setDistributionType(distributionTypeEnum);
        VariableImplementation var = new VariableImplementation(builder, this.allVariables.size());
        if (this.mapping.containsKey(var.getName())) {
            throw new IllegalArgumentException("Attribute list contains duplicated names");
        }
        this.mapping.put(var.getName(), var.getVarID());
        this.allVariables.add(var);
        return var;
    }

    public Variable newVariable(Attribute att, DistributionTypeEnum distributionTypeEnum, String name) {
        VariableBuilder builder = new VariableBuilder(att);
        builder.setDistributionType(distributionTypeEnum);
        builder.setName(name);
        VariableImplementation var = new VariableImplementation(builder, this.allVariables.size());
        if (this.mapping.containsKey(var.getName())) {
            throw new IllegalArgumentException("Attribute list contains duplicated names");
        }
        this.mapping.put(var.getName(), var.getVarID());
        this.allVariables.add(var);
        return var;
    }

    public Variable newVariable(Attribute att) {
        VariableBuilder builder = new VariableBuilder(att);
        VariableImplementation var = new VariableImplementation(builder, this.allVariables.size());
        if (this.mapping.containsKey(var.getName())) {
            throw new IllegalArgumentException("Attribute list contains duplicated names");
        }
        this.mapping.put(var.getName(), var.getVarID());
        this.allVariables.add(var);
        return var;
    }

    private Variable newVariable(String name, DistributionTypeEnum distributionTypeEnum, StateSpaceType stateSpaceType) {
        VariableBuilder builder = new VariableBuilder();
        builder.setName(name);
        builder.setDistributionType(distributionTypeEnum);
        builder.setStateSpaceType(stateSpaceType);
        builder.setObservable(false);
        return this.newVariable(builder);
    }

    public Variable newVariable(VariableBuilder builder) {
        VariableImplementation var = new VariableImplementation(builder, this.allVariables.size());
        if (this.mapping.containsKey(var.getName())) {
            throw new IllegalArgumentException("Attribute list contains duplicated names: " + var.getName());
        }
        this.mapping.put(var.getName(), var.getVarID());
        this.allVariables.add(var);
        return var;
    }

    public Variable getVariableById(int varID) {
        return this.allVariables.get(varID);
    }

    public Variable getVariableByName(String name) {
        Integer index = this.mapping.get(name);
        if (index == null) {
            throw new UnsupportedOperationException("Variable " + name + " is not part of the list of Variables");
        }
        return this.getVariableById(index);
    }

    public int getNumberOfVars() {
        return this.allVariables.size();
    }

    @Override
    public Iterator<Variable> iterator() {
        return this.allVariables.iterator();
    }

    public void block() {
    }

    public List<Variable> getListOfVariables() {
        return this.allVariables;
    }

    public static Variables auxiliarBuilder(List<Variable> variables) {
        return new Variables(variables);
    }

    private Variables(List<Variable> variables) {
        this.allVariables.addAll(variables);
        this.mapping = new HashMap<String, Integer>();
        for (Variable var : this.allVariables) {
            this.mapping.put(var.getName(), var.getVarID());
        }
    }

    public List<Variable> getVariablesForListOfAttributes(List<Attribute> attributeList) {
        return attributeList.parallelStream().map(att -> this.getVariableByName(att.getName())).collect(Collectors.toList());
    }

    private static class VariableImplementation
    implements Variable,
    Serializable {
        private static final long serialVersionUID = 4656207896676444152L;
        private String name;
        private int varID;
        private boolean observable;
        private StateSpaceType stateSpaceType;
        private DistributionTypeEnum distributionTypeEnum;
        private DistributionType distributionType;
        private Attribute attribute;
        private int numberOfStates = -1;

        public VariableImplementation(VariableBuilder builder, int varID) {
            this.name = builder.getName();
            this.varID = varID;
            this.observable = builder.isObservable();
            this.stateSpaceType = builder.getStateSpaceType();
            this.distributionTypeEnum = builder.getDistributionType();
            this.attribute = builder.getAttribute();
            if (((StateSpaceType)this.getStateSpaceType()).getStateSpaceTypeEnum() == StateSpaceTypeEnum.FINITE_SET) {
                this.numberOfStates = ((FiniteStateSpace)this.stateSpaceType).getNumberOfStates();
            }
            if (((StateSpaceType)this.getStateSpaceType()).getStateSpaceTypeEnum() == StateSpaceTypeEnum.SPARSE_FINITE_SET) {
                this.numberOfStates = ((SparseFiniteStateSpace)this.stateSpaceType).getNumberOfStates();
            }
            this.distributionType = this.distributionTypeEnum.newDistributionType(this);
        }

        public void setAttribute(Attribute attribute) {
            this.attribute = attribute;
            this.observable = attribute != null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getVarID() {
            return this.varID;
        }

        @Override
        public boolean isObservable() {
            return this.observable;
        }

        @Override
        public <E extends StateSpaceType> E getStateSpaceType() {
            return (E)this.stateSpaceType;
        }

        @Override
        public DistributionTypeEnum getDistributionTypeEnum() {
            return this.distributionTypeEnum;
        }

        @Override
        public <E extends DistributionType> E getDistributionType() {
            return (E)this.distributionType;
        }

        @Override
        public boolean isInterfaceVariable() {
            return false;
        }

        @Override
        public Attribute getAttribute() {
            return this.attribute;
        }

        @Override
        public boolean isDynamicVariable() {
            return false;
        }

        @Override
        public boolean isParameterVariable() {
            return false;
        }

        @Override
        public VariableBuilder getVariableBuilder() {
            VariableBuilder variableBuilder = new VariableBuilder();
            variableBuilder.setAttribute(this.getAttribute());
            variableBuilder.setDistributionType(this.getDistributionTypeEnum());
            variableBuilder.setName(this.getName());
            variableBuilder.setObservable(this.observable);
            variableBuilder.setStateSpaceType((StateSpaceType)this.getStateSpaceType());
            return variableBuilder;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable var = (Variable)o;
            return this.getVarID() == var.getVarID();
        }

        @Override
        public int getNumberOfStates() {
            return this.numberOfStates;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

