% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/power.R
\name{setPower}
\alias{setPower}
\title{Representing the power}
\usage{
setPower(d, method, alpha = 0.05)
}
\arguments{
\item{d}{effect size.}

\item{method}{character string, should be one of \code{"sim"} or \code{"exact"}, see Description.}

\item{alpha}{significance level.}
}
\value{
\code{S4} object of class \code{power}, a formal representation of the
issue of power in a clinical trial.
}
\description{
Represents the expected power of the individual randomization sequences.
}
\details{
The attained power of an individual randomization sequence can be an issue
in the design of a clinical trial. The power of a randomization sequence is
is computed dependent on the effect size \code{d} and the difference in
group sizes in the end if.

If \code{method="sim"}, the object represents the simulated power of an
individual randomization sequence. When calling \code{assess} for a
\code{power} object with \code{method="sim"}, one test decision is computed
for each randomization sequence of \code{randSeq}. The power is the
proportion of falsely (correctly) rejected null hypotheses.

If \code{method="exact"}, the object represents the exact power of an
individual randomization sequence. When calling \code{assess} for a
\code{power} object with \code{method="exact"}, the exact \emph{p}-value
of each randomization sequence is computed. So far, this is only supported
for normal endpoints. Then the power is the sum of the corresponding
quantiles of the noncentral t-distribution.
}
\seealso{
Other issues: \code{\link{chronBias}};
  \code{\link{corGuess}}; \code{\link{imbal}};
  \code{\link{issue}}, \code{\link{issues}};
  \code{\link{selBias}}
}

