% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_set.R
\name{rmap_add_ranges}
\alias{rmap_add_ranges}
\alias{rmap_add_ranges,rmapConnection,sf,character-method}
\title{Add polygons to a rangeMapper project}
\usage{
rmap_add_ranges(con, x, ID)

\S4method{rmap_add_ranges}{rmapConnection,sf,character}(con, x, ID)
}
\arguments{
\item{con}{a rangeMapper connection made with   \code{\link[=rmap_connect]{rmap_connect()}}.}

\item{x}{a spatial polygon object of class \code{sf} (see \code{\link[sf:st_as_sf]{sf::st_as_sf()}} ) .}

\item{ID}{character string. name of the ID column, usually species name.}
}
\value{
TRUE when the table is written to the project file, FALSE otherwise.
}
\description{
Add polygon ranges (usually species or populations distribution ranges) to a rangeMapper project
}
\details{
Polygons are saved as WKB (see \code{\link[sf:st_as_binary]{sf::st_as_binary()}}).
}
\examples{
con = rmap_connect()
rmap_add_ranges(con, x = wrens, ID = 'sci_name')
dbDisconnect(con)

}
