% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_helpers.R
\name{plot_ranges}
\alias{plot_ranges}
\title{Helper to plot multiple ranges on top of environmental layers}
\usage{
plot_ranges(sp_ranges, sp_records = NULL, variable, range_colors = NULL,
            color_variable = NULL, xlim = NULL, ylim = NULL)
}
\arguments{
\item{sp_ranges}{list of SpatialPolygonsDataFrame objects representing
species ranges.}

\item{sp_records}{a SpatialPointsDataFrame of species occurrences.}

\item{variable}{a RasterLayer representing an environmental variable.}

\item{range_colors}{vector of colors for borders of species ranges. If
\code{NULL}, the default, distinct levels of gray will be used.}

\item{color_variable}{a color palette (a vector of continuous colors generated
by functions like heat.colors). If \code{NULL}, the default, rev(terrain.colors(255))
will be used.}

\item{xlim}{the x limits (x1, x2) of the plot. \code{NULL} indicates that
the range of values to be plotted will define limits.}

\item{ylim}{the y limits (x1, x2) of the plot.}
}
\value{
A plot showing species ranges on top of a environmental variable.
}
\description{
Helper to plot multiple ranges on top of environmental layers
}
\examples{
# example data
data("buffer_range", package = "rangemap")
data("cxhull_range", package = "rangemap")

ranges <- list(buffer_range@species_range, cxhull_range@species_range)

var <- raster::stack(system.file("extdata", "variables.tif",
                                 package = "rangemap"))[[1]]

# plotting
plot_ranges(ranges, variable = var)
}
