% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterLocalMoments.R
\name{rasterLocalMoments}
\alias{rasterLocalMoments}
\title{Local moments for an in memory raster image}
\usage{
rasterLocalMoments(r, WMu, WVar = WMu, moments = 2)
}
\arguments{
\item{r}{An in memory raster image.}

\item{WMu}{A matrix of weights.  The mean kernel will be applied to each 
pixel in \code{r}.  Dimensions must be non-zero and odd.  Only non-missing 
neighbors are used in the mean.}

\item{WVar}{A matrix of weights.  The variance kernel will be applied at each 
centroid.  Dimensions must be non-zero and odd.  Only non-missing 
neighbors are used in the variance. The dimensions of WVar must match WMu.}

\item{moments}{The number of moments to calculate. The local spatial mean
will be calculated when moments=1.  The local spatial mean and variance
wil be calculated when moments=2.  Currently no higher moments are supported.}
}
\value{
A list of in memory raster images, one list element for each moment.
}
\description{
\code{rasterLocalMoments} finds the local moments within the weighted neighborhood 
of W.
}
\examples{
r <- raster::raster( matrix(rnorm(36),6,6)) 
W <- matrix(1,3,3)
rLocalMoments <- rasterLocalMoments(r,W)
}

