% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rba-functions.R
\name{rba_read_tss}
\alias{rba_read_tss}
\title{Read RBA statistical time series spreadsheet}
\usage{
rba_read_tss(files)
}
\arguments{
\item{files}{Names of one or more ABS data file}
}
\value{
data frame in long format
}
\description{
Functions to extract data from a specified RBA time series spreadsheet.
}
\examples{
 \donttest{
   rba_urls <- rba_search(pattern = "Liabilities and Assets")$url
   rba_files <- sapply(rba_urls, rba_file_download)
   data <- rba_read_tss(rba_files);
 }
}
\author{
David Mitchell <david.pk.mitchell@gmail.com>
}
