% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-electrode-lfp.R
\name{LFP_electrode}
\alias{LFP_electrode}
\title{Definition for 'LFP' electrodes}
\description{
Definition for 'LFP' electrodes

Definition for 'LFP' electrodes
}
\examples{
\dontrun{

# Download demo subject KC

# Electrode 14
e <- LFP_electrode$new(subject = 'demo/DemoSubject',
                       number = 14, is_reference = FALSE)

# Reference "ref_13-16,24"
ref <- LFP_electrode$new(subject = 'demo/DemoSubject',
                         number = "ref_13-16,24", is_reference = TRUE)

# ------ Reference ------
# By default there is no reference
e$reference_name     # "noref

# set reference
e$set_reference(reference = ref)
e$reference_name     # "ref_13-16,24"

# Set epoch
e$set_epoch(epoch = 'auditory_onset')

# Now epoch power
power <- e$epoch_power(before_onset = 1, after_onset = 2)

# Trial x Frequency x Time x Electrodes
power

# Subset power
subset(power, Time ~ Time < 0, Electrode ~ Electrode == 14)

# clear memory in RAM and cache on hard disk
e$clear_cache()
e$clear_memory()


}

}
\section{Super class}{
\code{\link[raveio:RAVEAbstarctElectrode]{raveio::RAVEAbstarctElectrode}} -> \code{LFP_electrode}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{type}}{type of electrode}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{exists}}{whether electrode exists in subject}

\item{\code{h5_fname}}{'HDF5' file name}

\item{\code{valid}}{whether current electrode is valid: subject exists and
contains current electrode or reference; subject electrode type matches
with current electrode type}

\item{\code{raw_sample_rate}}{voltage sample rate}

\item{\code{power_sample_rate}}{power/phase sample rate}

\item{\code{preprocess_info}}{preprocess information}

\item{\code{power_file}}{path to power 'HDF5' file}

\item{\code{phase_file}}{path to phase 'HDF5' file}

\item{\code{voltage_file}}{path to voltage 'HDF5' file}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-set_reference}{\code{LFP_electrode$set_reference()}}
\item \href{#method-new}{\code{LFP_electrode$new()}}
\item \href{#method-.load_noref_wavelet}{\code{LFP_electrode$.load_noref_wavelet()}}
\item \href{#method-.load_noref_voltage}{\code{LFP_electrode$.load_noref_voltage()}}
\item \href{#method-.load_wavelet}{\code{LFP_electrode$.load_wavelet()}}
\item \href{#method-.load_voltage}{\code{LFP_electrode$.load_voltage()}}
\item \href{#method-load_data}{\code{LFP_electrode$load_data()}}
\item \href{#method-load_unreferenced_voltage}{\code{LFP_electrode$load_unreferenced_voltage()}}
\item \href{#method-load_unreferenced_power}{\code{LFP_electrode$load_unreferenced_power()}}
\item \href{#method-load_unreferenced_phase}{\code{LFP_electrode$load_unreferenced_phase()}}
\item \href{#method-reference_power}{\code{LFP_electrode$reference_power()}}
\item \href{#method-reference_phase}{\code{LFP_electrode$reference_phase()}}
\item \href{#method-reference_voltage}{\code{LFP_electrode$reference_voltage()}}
\item \href{#method-clear_cache}{\code{LFP_electrode$clear_cache()}}
\item \href{#method-clear_memory}{\code{LFP_electrode$clear_memory()}}
\item \href{#method-clone}{\code{LFP_electrode$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="raveio" data-topic="RAVEAbstarctElectrode" data-id=".set_reference">}\href{../../raveio/html/RAVEAbstarctElectrode.html#method-.set_reference}{\code{raveio::RAVEAbstarctElectrode$.set_reference()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="raveio" data-topic="RAVEAbstarctElectrode" data-id="set_epoch">}\href{../../raveio/html/RAVEAbstarctElectrode.html#method-set_epoch}{\code{raveio::RAVEAbstarctElectrode$set_epoch()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_reference"></a>}}
\if{latex}{\out{\hypertarget{method-set_reference}{}}}
\subsection{Method \code{set_reference()}}{
set reference for current electrode
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$set_reference(reference)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reference}}{either \code{NULL} or \code{LFP_electrode} instance}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$new(subject, number, is_reference = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subject, number, is_reference}}{see constructor in
\code{\link{RAVEAbstarctElectrode}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.load_noref_wavelet"></a>}}
\if{latex}{\out{\hypertarget{method-.load_noref_wavelet}{}}}
\subsection{Method \code{.load_noref_wavelet()}}{
load non-referenced wavelet coefficients (internally used)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$.load_noref_wavelet(reload = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reload}}{whether to reload cache}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.load_noref_voltage"></a>}}
\if{latex}{\out{\hypertarget{method-.load_noref_voltage}{}}}
\subsection{Method \code{.load_noref_voltage()}}{
load non-referenced voltage (internally used)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$.load_noref_voltage(srate, reload = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{srate}}{voltage signal sample rate}

\item{\code{reload}}{whether to reload cache}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.load_wavelet"></a>}}
\if{latex}{\out{\hypertarget{method-.load_wavelet}{}}}
\subsection{Method \code{.load_wavelet()}}{
load referenced wavelet coefficients (internally used)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$.load_wavelet(type = c("power", "phase", "coef"), reload = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{type of data to load}

\item{\code{reload}}{whether to reload cache}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.load_voltage"></a>}}
\if{latex}{\out{\hypertarget{method-.load_voltage}{}}}
\subsection{Method \code{.load_voltage()}}{
load referenced voltage (internally used)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$.load_voltage(reload = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reload}}{whether to reload cache}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-load_data"></a>}}
\if{latex}{\out{\hypertarget{method-load_data}{}}}
\subsection{Method \code{load_data()}}{
method to load electrode data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$load_data(
  type = c("power", "phase", "voltage", "wavelet-coefficient")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{data type such as \code{"power"}, \code{"phase"},
\code{"voltage"}, \code{"wavelet-coefficient"}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-load_unreferenced_voltage"></a>}}
\if{latex}{\out{\hypertarget{method-load_unreferenced_voltage}{}}}
\subsection{Method \code{load_unreferenced_voltage()}}{
load voltage data, non-referenced
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$load_unreferenced_voltage(block, persist = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{block}}{experiment block}

\item{\code{persist}}{whether to persist in the instance, default is false,
however, if this function will be called multiple times, set it to true.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
voltage data before reference
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-load_unreferenced_power"></a>}}
\if{latex}{\out{\hypertarget{method-load_unreferenced_power}{}}}
\subsection{Method \code{load_unreferenced_power()}}{
load power data, non-referenced
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$load_unreferenced_power(block, persist = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{block}}{experiment block}

\item{\code{persist}}{whether to persist in the instance, default is false,
however, if this function will be called multiple times, set it to true.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
power data before reference
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-load_unreferenced_phase"></a>}}
\if{latex}{\out{\hypertarget{method-load_unreferenced_phase}{}}}
\subsection{Method \code{load_unreferenced_phase()}}{
load phase data, non-referenced
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$load_unreferenced_phase(block, persist = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{block}}{experiment block}

\item{\code{persist}}{whether to persist in the instance, default is false,
however, if this function will be called multiple times, set it to true.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
phase data before reference
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reference_power"></a>}}
\if{latex}{\out{\hypertarget{method-reference_power}{}}}
\subsection{Method \code{reference_power()}}{
reference power for given block
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$reference_power(block)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{block}}{character, experiment block}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
referenced power
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reference_phase"></a>}}
\if{latex}{\out{\hypertarget{method-reference_phase}{}}}
\subsection{Method \code{reference_phase()}}{
reference phase for given block
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$reference_phase(block)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{block}}{character, experiment block}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
referenced phase
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reference_voltage"></a>}}
\if{latex}{\out{\hypertarget{method-reference_voltage}{}}}
\subsection{Method \code{reference_voltage()}}{
reference voltage for given block
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$reference_voltage(block)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{block}}{character, experiment block}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
referenced voltage
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clear_cache"></a>}}
\if{latex}{\out{\hypertarget{method-clear_cache}{}}}
\subsection{Method \code{clear_cache()}}{
method to clear cache on hard drive
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$clear_cache(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clear_memory"></a>}}
\if{latex}{\out{\hypertarget{method-clear_memory}{}}}
\subsection{Method \code{clear_memory()}}{
method to clear memory
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$clear_memory(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
