% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json.R
\name{save_json}
\alias{save_json}
\alias{load_json}
\title{Save or load R object in 'JSON' format}
\usage{
save_json(
  x,
  con = stdout(),
  ...,
  digits = ceiling(-log10(.Machine$double.eps)),
  pretty = TRUE,
  serialize = TRUE
)

load_json(con, ..., map = NULL)
}
\arguments{
\item{x}{R object to save}

\item{con}{file or connection}

\item{...}{other parameters to pass into \code{\link[jsonlite]{toJSON}} or
\code{\link[jsonlite]{fromJSON}}}

\item{digits}{number of digits to save}

\item{pretty}{whether the output should be pretty}

\item{serialize}{whether to save a serialized version of \code{x};
see 'Examples'.}

\item{map}{a map to save the results}
}
\value{
\code{save_json} returns nothing; \code{load_json} returns an
R object.
}
\description{
Save or load R object in 'JSON' format
}
\examples{


# Serialize
save_json(list(a = 1, b = function(){}))

# use toJSON
save_json(list(a = 1, b = function(){}), serialize = FALSE)


# Demo of using serializer
f1 <- tempfile(fileext = ".json")
save_json(x ~ y + 1, f1)

load_json(f1)

unlink(f1)


}
