% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blackrock-parser.R
\name{read_nsx_nev}
\alias{read_nsx_nev}
\title{Read 'BlackRock' event and signal files}
\usage{
read_nsx_nev(
  paths,
  nev_path = NULL,
  header_only = FALSE,
  nev_data = TRUE,
  verbose = TRUE,
  ram = FALSE,
  force_update = FALSE,
  temp_path = file.path(tempdir(), "blackrock-temp")
)
}
\arguments{
\item{paths}{'NSx' signal files, usually with file extensions such as
\code{'.ns1'}, \code{'.ns2'}, \code{'.ns3'}, \code{'.ns4'}, \code{'.ns5'}.}

\item{nev_path}{'NEV' event files, with file extension \code{'.nev'}}

\item{header_only}{whether to load header information only and avoid
reading signal arrays}

\item{nev_data}{whether to load \code{'.nev'} comments and 'waveforms'}

\item{verbose}{whether to print out progress when loading signal array}

\item{ram}{whether to load signals into the memory rather than storing
with \code{\link[filearray]{filearray}}; default is false}

\item{force_update}{force updating the channel data even if the headers
haven't changed}

\item{temp_path}{temporary directory to store the channel data}
}
\description{
Current implementation supports minimum 2.3 file
specification version. Please contact the package maintainer to add
specification configurations if you want us to support older versions.
}
