% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-utils.R
\name{rcond_filter_ar}
\alias{rcond_filter_ar}
\title{Computer reciprocal condition number of an 'Arma' filter}
\usage{
rcond_filter_ar(a)
}
\arguments{
\item{a}{auto-regression coefficient, numerical vector; the first element
must not be zero}
}
\value{
Reciprocal condition number of matrix \code{z1}, used in
\code{\link{filtfilt}}. If the number is less than
\code{.Machine$double.eps}, then \code{\link{filtfilt}} will fail.
}
\description{
Test whether the filter is numerically stable for \code{\link{filtfilt}}.
}
\examples{


# Butterworth filter with low-pass at 0.1 Hz (order = 4)
filter <- butter(4, 0.1, "low")

# TRUE
rcond_filter_ar(filter$a) > .Machine$double.eps

diagnose_filter(filter$b, filter$a, 500)

# Bad filter (order is too high)
filter <- butter(50, 0.1, "low")

rcond_filter_ar(filter$a) > .Machine$double.eps

# filtfilt needs to inverse a singular matrix
diagnose_filter(filter$b, filter$a, 500)

}
\seealso{
\code{\link{check_filter}}
}
