% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csg_construct.R
\name{csg_translate}
\alias{csg_translate}
\title{CSG Translate}
\usage{
csg_translate(object, x = 0, y = 0, z = 0)
}
\arguments{
\item{object}{CSG object.}

\item{x}{Default `0`. x translation.}

\item{y}{Default `0`. y translation.}

\item{z}{Default `0`. z translation.}
}
\value{
List describing the triangle in the scene.
}
\description{
CSG Translate
}
\examples{
\donttest{
#Translate a simple object:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_torus(), material=glossy(color="dodgerblue4"))) \%>\%
  add_object(csg_object(csg_translate(csg_torus(),x=-2,y=1,z=-2), 
                        material=glossy(color="red"))) \%>\%
  add_object(sphere(y=5,x=5,radius=3,material=light(intensity=10))) \%>\%  
  render_scene(clamp_value=10,lookfrom=c(0,5,10),fov=30,
               lookat=c(-1,0.5,-1))

#Translate a blended object:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_combine(
    csg_torus(),
    csg_torus(y=1, radius=0.8), operation="blend"), material=glossy(color="dodgerblue4"))) \%>\%
  add_object(csg_object(csg_translate(
    csg_combine(
      csg_torus(),
      csg_torus(y=1, radius=0.8), operation="blend"),
    x=-3,y=1,z=-3),
    material=glossy(color="red"))) \%>\%
  add_object(sphere(y=5,x=5,radius=3,material=light(intensity=10))) \%>\%  
  render_scene(clamp_value=10,lookfrom=c(0,5,10),fov=30,
               lookat=c(-1.5,0.5,-1.5))
}
}
