% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_to_matrix.R
\name{raster_to_matrix}
\alias{raster_to_matrix}
\title{Raster to Matrix}
\usage{
raster_to_matrix(raster, verbose = interactive())
}
\arguments{
\item{raster}{The input raster. Either a RasterLayer object, a terra SpatRaster object, or a filename.}

\item{verbose}{Default `interactive()`. Will print dimensions of the resulting matrix.}
}
\description{
Turns a raster into a matrix suitable for rayshader.
}
\examples{
#Save montereybay as a raster and open using the filename.
if(rayshader:::run_documentation()) {
temp_raster_filename = paste0(tempfile(),".tif")
raster::writeRaster(raster::raster(t(montereybay)),temp_raster_filename)
elmat = raster_to_matrix(temp_raster_filename)
elmat \%>\%
 sphere_shade() \%>\%
 plot_map()
}
}
