% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swap_yz.R
\name{swap_yz}
\alias{swap_yz}
\title{Swap Y/Z Axis}
\usage{
swap_yz(mesh)
}
\arguments{
\item{mesh}{A raymesh object.}
}
\value{
Mesh with Y and Z axis exchanged
}
\description{
Swap Y/Z Axis
}
\examples{
# Flip a mesh that's originally aligned along the y-axis
if(run_documentation()) {
cyl_mat = material_list(ambient="red", ambient_intensity=0.3, 
                        diffuse="red", diffuse_intensity=0.7)
change_material(cylinder_mesh(length = 3, position=c(0,2,0), material = cyl_mat),
                diffuse="green", ambient="green") |> 
  add_shape(swap_yz(cylinder_mesh(position=c(0,2,0), length=3, material = cyl_mat))) |> 
  rasterize_scene(lookfrom=c(10,10,10), lookat=c(0,0,0), fov=40,
                  light_info = directional_light(c(1,1,-1)),
                  line_info = generate_line(end=c(10,0,0)) |> 
                  add_lines(generate_line(end=c(0,10,0),color="green")) |> 
                  add_lines(generate_line(end=c(0,0,10),color="red")))
}
}
