% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomes.R
\name{Biomes}
\alias{Biomes}
\alias{get_biomes_data}
\alias{get_biomes_value}
\alias{put_biomes_data}
\alias{put_biomes_values}
\alias{put_biomes_value}
\title{Read and write biome data.}
\usage{
get_biomes_data(db, x, z, dimension, return_names = TRUE)

get_biomes_value(db, x, z, dimension, return_names = TRUE)

put_biomes_data(db, data, missing_height = 0L)

put_biomes_values(db, x, z, dimension, values, missing_height = 0L)

put_biomes_value(db, x, z, dimension, value, missing_height = 0L)
}
\arguments{
\item{db}{A bedrockdb object.}

\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{return_names}{return biome names instead of biome ids.}

\item{data}{A list of character or integer vectors. Each element of
the list must contain 256 values or an error will be raised.}

\item{missing_height}{if there is no existing height data, use this value
for the chunk.}

\item{values}{a list of arrays containing biome names or ids.}

\item{value}{an array containing biome names or ids.}
}
\value{
\code{get_biomes_data()} returns a list of the of the values returned by
\code{get_biome_value()}.

An array containing biome information, with dimension "x" and "z".
The indexes of the array are a horizontal position relative to the
chunk origin.
}
\description{
Biome data is stored as the second map in the 2DMaps data (tag 45). Each
chunk stores its biome data as 256 uint8s.

\code{get_biomes_data()} loads biomes data from a \code{bedrockdb}.
It will silently drop and keys not representing 2DMaps data.

\code{get_biomes_value()} loads biome data from a \code{bedrockdb}.
It only supports loading a single value.

\code{put_biomes_data()} \code{put_biomes_values()}, and \code{put_biomes_value()} update
the biome information of chunks. They preserve any existing height data.
}
