% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbt.R
\name{get_nbt_data}
\alias{get_nbt_data}
\alias{get_nbt_value}
\alias{get_nbt_values}
\alias{put_nbt_values}
\alias{put_nbt_value}
\alias{put_nbt_data}
\alias{read_nbt}
\alias{write_nbt}
\alias{read_nbt_data}
\alias{write_nbt_data}
\title{Read and Write NBT Data}
\usage{
get_nbt_data(
  db,
  keys,
  readoptions = NULL,
  max_elements = NULL,
  simplify = TRUE
)

get_nbt_value(
  db,
  key,
  readoptions = NULL,
  max_elements = NULL,
  simplify = TRUE
)

get_nbt_values(
  db,
  keys,
  readoptions = NULL,
  max_elements = NULL,
  simplify = TRUE
)

put_nbt_values(db, keys, values, writeoptions = NULL)

put_nbt_value(db, key, value, writeoptions = NULL)

put_nbt_data(db, data, writeoptions = NULL)

read_nbt(rawdata, max_elements = NULL, simplify = TRUE)

write_nbt(object)

read_nbt_data(data, max_elements = NULL, simplify = TRUE)

write_nbt_data(data)
}
\arguments{
\item{db}{A \code{bedrockdb} object}

\item{keys}{A character vector of keys.}

\item{readoptions}{A \code{bedrock_leveldb_readoptions} object}

\item{max_elements}{Maximum number of elements to parse.}

\item{simplify}{If TRUE, simplifies a list containing a single unnamed \code{nbtnode}.}

\item{key}{A single key.}

\item{values}{A list of nbt objects}

\item{writeoptions}{A \code{bedrock_leveldb_writeoptions} object}

\item{value}{An nbt object.}

\item{data}{A named-list specifying key-value pairs.}

\item{rawdata}{A \code{raw} vector}

\item{object}{An nbt object or a list of nbt objects}
}
\description{
\code{get_nbt_data()} and \code{get_nbt_value()} load nbt-formatted data from \code{db} and parses it.
\code{get_nbt_values()} is a synonym for \code{get_nbt_data()}.

\code{put_nbt_values}, \code{put_nbt_value}, and \code{put_nbt_data} stores nbt data into \code{db} in binary form.

\code{read_nbt} reads NBT data from a \code{raw} vector.

\code{write_nbt} encodes NBT data into a \code{raw} vector.

\code{read_nbt_data} calls \code{read_nbt} on each element of a list.

\code{write_nbt_data} calls \code{write_nbt} on each element of a list.
}
\details{
The Named Binary Tag (NBT) format is used by Minecraft for various data types.
}
