% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhl_subjectmetadata.R
\name{bhl_subjectmetadata}
\alias{bhl_subjectmetadata}
\title{Get metadata about a subject}
\usage{
bhl_subjectmetadata(subject, pubs = FALSE, as = "table", key = NULL, ...)
}
\arguments{
\item{subject}{(character) he subject for which to return metadata}

\item{pubs}{(logical) \code{TRUE} to return the subject's publications.
Default: \code{FALSE}}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"),
or parsed table ("table", default). Note that \code{as="table"} can give
different data format back depending on the function - for example,
sometimes a data.frame and sometimes a character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron}
as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\description{
Get metadata about a subject
}
\details{
You may choose to include a list of the subject's publications.
The BHLType element identifies the type of each publication (Title or Part).
}
\examples{
\dontrun{
bhl_subjectmetadata(subject = "water")
x <- bhl_subjectmetadata(subject = "water", pubs = TRUE)
head(x$Publications[[1]])
}
}
