% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbin-winsorize.R
\name{rbin_winsorize}
\alias{rbin_winsorize}
\alias{plot.rbin_winsorize}
\title{Winsorized binning}
\usage{
rbin_winsorize(
  data = NULL,
  response = NULL,
  predictor = NULL,
  bins = 10,
  include_na = TRUE,
  winsor_rate = 0.05,
  min_val = NULL,
  max_val = NULL,
  type = 7,
  remove_na = TRUE
)

\method{plot}{rbin_winsorize}(x, print_plot = TRUE, ...)
}
\arguments{
\item{data}{A \code{data.frame} or \code{tibble}.}

\item{response}{Response variable.}

\item{predictor}{Predictor variable.}

\item{bins}{Number of bins.}

\item{include_na}{logical; if \code{TRUE}, a separate bin is created for missing values.}

\item{winsor_rate}{A value from 0.0 to 0.5.}

\item{min_val}{the low border, all values being lower than this will be replaced by this value. The default is set to the 5 percent quantile of predictor.}

\item{max_val}{the high border, all values being larger than this will be replaced by this value. The default is set to the 95 percent quantile of predictor.}

\item{type}{an integer between 1 and 9 selecting one of the nine quantile algorithms detailed in \code{quantile()} to be used.}

\item{remove_na}{logical; if \code{TRUE} NAs will removed while calculating quantiles}

\item{x}{An object of class \code{rbin_winsorize}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A \code{tibble}.
}
\description{
Bin continuous data using winsorized method.
}
\examples{
bins <- rbin_winsorize(mbank, y, age, 10, winsor_rate = 0.05)
bins

# plot
plot(bins)

}
