% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaspar.R
\name{rba_jaspar_releases}
\alias{rba_jaspar_releases}
\title{Get information about JASPAR database releases}
\usage{
rba_jaspar_releases(release_number = NULL, ...)
}
\arguments{
\item{release_number}{Numeric: Which JASPAR database release number
information's to retrieve? If left NULL (the default), a list of all
JASPAR database releases will be returned. Available options are 1 to 8.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list that contains all JASPAR database releases' information or
  details of a particular release.
}
\description{
If a release number was supplied, this function will return the details
  of that release. Otherwise, if the function was called without "release"
  argument, a list of all JASPAR database releases will be returned.
}
\section{Corresponding API Resources}{

"GET "https://jaspar.genereg.net/api/v1/releases/"
 "GET "https://jaspar.genereg.net/api/v1/releases/{release_number}/"
}

\examples{
\donttest{
rba_jaspar_releases()
rba_jaspar_releases(7)
}

}
\references{
\itemize{
  \item Jaime A Castro-Mondragon, Rafael Riudavets-Puig, Ieva
  Rauluseviciute, Roza Berhanu Lemma, Laura Turchi, Romain Blanc-Mathieu,
  Jeremy Lucas, Paul Boddie, Aziz Khan, Nicolás Manosalva Pérez, Oriol
  Fornes, Tiffany Y Leung, Alejandro Aguirre, Fayrouz Hammal, Daniel
  Schmelter, Damir Baranasic, Benoit Ballester, Albin Sandelin, Boris
  Lenhard, Klaas Vandepoele, Wyeth W Wasserman, François Parcy,
  Anthony Mathelier, JASPAR 2022: the 9th release of the open-access
  database of transcription factor binding profiles, Nucleic Acids
  Research, Volume 50, Issue D1, 7 January 2022, Pages D165–D173,
  https://doi.org/10.1093/nar/gkab1113
  \item
  \href{https://jaspar.genereg.net/api/v1/docs/}{JASPAR API Documentation}
  \item \href{https://jaspar.genereg.net/faq/}{Citations note
  on JASPAR website}
  }
}
\seealso{
Other "JASPAR": 
\code{\link{rba_jaspar_collections_matrices}()},
\code{\link{rba_jaspar_collections}()},
\code{\link{rba_jaspar_matrix_search}()},
\code{\link{rba_jaspar_matrix_versions}()},
\code{\link{rba_jaspar_matrix}()},
\code{\link{rba_jaspar_sites}()},
\code{\link{rba_jaspar_species_matrices}()},
\code{\link{rba_jaspar_species}()},
\code{\link{rba_jaspar_taxons_matrices}()},
\code{\link{rba_jaspar_taxons}()},
\code{\link{rba_jaspar_tffm_search}()},
\code{\link{rba_jaspar_tffm}()}
}
\concept{"JASPAR"}
