% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_interactors_static}
\alias{rba_reactome_interactors_static}
\title{Get Static(IntAct) Interaction Information of a Protein}
\usage{
rba_reactome_interactors_static(
  proteins,
  endpoint = "details",
  only_diagrammed = FALSE,
  species = NULL,
  ...
)
}
\arguments{
\item{proteins}{Uniprot proteins accession(s). If endpoint = "pathway",
only a single protein accession can be supplied.}

\item{endpoint}{Can be one of: \enumerate{
\item "details": To return a detailed information of your supplied
protein(s) accession.
\item "summary": To return a summary of your supplied protein(s) accession
\item "pathway": To return a list of pathways containing the interacting
molecules (excluding TopLevelPathway class).}}

\item{only_diagrammed}{Logical: (only when "endpoint = "pathway")
If TRUE, pathways without diagram will be excluded. (default = FALSE)}

\item{species}{Only when "endpoint = "pathway", The scientific name
of the species to search for the pathways. See
 \code{\link{rba_reactome_species}} or
 \href{https://reactome.org/content/schema/objects/Species/}{Reactome
 Data Schema: Entries: Species}.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
List which it's content varies based on the  supplied "endpoint"
  argument.
}
\description{
Reactome maintain a locally host a version of IntAct(Static) interactions
  database. Using this function, you can retrieve IntAct information of
  a protein(s) in two scenarios: \enumerate{
  \item If endpoint = "details" or "summary": Retrieve a detailed/summary
    information of your supplied protein accession(s) from IntAct database.
  \item If endpoint = "pathway", Retrieve a list of Reactome pathways which
  include your supplied protein accession. Pathways with the class
  "TopLevelPathway" will be excluded.}
}
\section{Corresponding API Resources}{

 "POST https://reactome.org/ContentService/interactors/static/
 molecules/details"
 \cr "POST https://reactome.org/ContentService/interactors/static/
 molecules/summary"
 \cr "GET https://reactome.org/ContentService/interactors/static/
 molecules/pathways"
}

\examples{
\donttest{
rba_reactome_interactors_static(proteins = "Q9BXM7-1",
    endpoint = "pathways", species = "Homo sapiens")
}
\donttest{
rba_reactome_interactors_static(proteins = c("Q9BXM7-1", "Q13501"),
    endpoint = "details")
}
\donttest{
rba_reactome_interactors_static(proteins = c("Q9BXM7-1", "Q13501"),
    endpoint = "summary")
}

}
\references{
\itemize{
  \item Marc Gillespie, Bijay Jassal, Ralf Stephan, Marija Milacic, Karen
  Rothfels, Andrea Senff-Ribeiro, Johannes Griss, Cristoffer Sevilla, Lisa
  Matthews, Chuqiao Gong, Chuan Deng, Thawfeek Varusai, Eliot Ragueneau,
  Yusra Haider, Bruce May, Veronica Shamovsky, Joel Weiser, Timothy Brunson,
  Nasim Sanati, Liam Beckman, Xiang Shao, Antonio Fabregat, Konstantinos
  Sidiropoulos, Julieth Murillo, Guilherme Viteri, Justin Cook, Solomon
  Shorser, Gary Bader, Emek Demir, Chris Sander, Robin Haw, Guanming Wu,
  Lincoln Stein, Henning Hermjakob, Peter D’Eustachio, The reactome
  pathway knowledgebase 2022, Nucleic Acids Research, 2021;, kab1028,
  https://doi.org/10.1093/nar/gkab1028
  \item Griss J, Viteri G, Sidiropoulos K, Nguyen V, Fabregat A,
  Hermjakob H. ReactomeGSA - Efficient Multi-Omics Comparative Pathway
  Analysis. Mol Cell Proteomics. 2020 Sep 9. doi: 10.1074/mcp. PubMed
  PMID: 32907876.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  \item \href{https://reactome.org/cite/}{Citations note on Reactome website}
  }
}
\seealso{
Other "Reactome Content Service - Molecule Interactors": 
\code{\link{rba_reactome_interactors_psicquic}()}
}
\concept{"Reactome Content Service - Molecule Interactors"}
