% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stringdb.R
\name{rba_string_homology_intra}
\alias{rba_string_homology_intra}
\title{Get Similarity Scores Hits of Proteins in a Species}
\usage{
rba_string_homology_intra(ids, species = NULL, ...)
}
\arguments{
\item{ids}{Your protein ID(s). It is strongly recommended to supply
STRING IDs. See \code{\link{rba_string_map_ids}} for more information.}

\item{species}{Numeric: NCBI Taxonomy identifier; Human Taxonomy ID is 9606.
(Recommended, but optional if your input is less than 100 IDs.)}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A data frame with bit scores between your supplied proteins and
  their self-hit. To Reduce the transferred data, STRING returns only one
  half of the similarity matrix; This will not pose a problem because
  similarity matrix is symmetrical.
}
\description{
Using this function, you can retrieve the Smith-Waterman bit scores among
  proteins of the same species.
  Bit Scores serve as similarity scores between protein sequence;
  And, according to STRING documentations, as a proxy for protein homology.
}
\details{
Note that this function will retrieve similarity scores of different
  proteins "within the same species". To Get a similarity scores of a given
  protein and it's closets homologous proteins in other species, see
  \code{\link{rba_string_homology_inter}}.
  \cr Similarity matrix is imported -by STRING- from:
  \href{https://cube.univie.ac.at/resources/simap}{Similarity Matrix of
  Proteins (SIMAP)}
}
\section{Corresponding API Resources}{

 "POST https://string-db.org/api/\{output-format\}/homology?identifiers=
 \{your_identifiers\}"
}

\examples{
\donttest{
rba_string_homology_intra(ids = c("CDK1", "CDK2"), species = 9606)
}

}
\references{
\itemize{
  \item Damian Szklarczyk, Rebecca Kirsch, Mikaela Koutrouli, Katerina
   Nastou, Farrokh Mehryary, Radja Hachilif, Annika L Gable, Tao Fang,
   Nadezhda T Doncheva, Sampo Pyysalo, Peer Bork, Lars J Jensen, Christian
   von Mering, The STRING database in 2023: protein–protein association
   networks and functional enrichment analyses for any sequenced genome of
   interest, Nucleic Acids Research, Volume 51, Issue D1, 6 January 2023,
   Pages D638–D646, https://doi.org/10.1093/nar/gkac1000
  \item \href{https://string-db.org/help/api/}{STRING API Documentation}
  \item
  \href{https://string-db.org/cgi/about?footer_active_subpage=references}{
  Citations note on STRING website}
  }
}
\seealso{
\code{\link{rba_string_map_ids}, \link{rba_string_homology_inter}}

Other "STRING": 
\code{\link{rba_string_annotations}()},
\code{\link{rba_string_enrichment}()},
\code{\link{rba_string_enrichment_ppi}()},
\code{\link{rba_string_homology_inter}()},
\code{\link{rba_string_interaction_partners}()},
\code{\link{rba_string_interactions_network}()},
\code{\link{rba_string_map_ids}()},
\code{\link{rba_string_network_image}()},
\code{\link{rba_string_version}()}
}
\concept{"STRING"}
