% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.r
\name{phylogeny}
\alias{phylogeny}
\title{Get the phylogenetic tree.}
\usage{
phylogeny(biom)
}
\arguments{
\item{biom}{A \code{BIOM} object, as returned from \link{read.biom}.}
}
\value{
A \code{phylo} class object of the tree in \code{biom}.
}
\description{
Get the phylogenetic tree.
}
\examples{
    library(rbiom)
    
    infile <- system.file("extdata", "hmp50.biom", package = "rbiom")
    biom <- read.biom(infile)
    
    summary(phylogeny(biom))

}
\seealso{
Other accessor functions: 
\code{\link{counts}()},
\code{\link{info}()},
\code{\link{metadata}()},
\code{\link{nsamples}()},
\code{\link{ntaxa}()},
\code{\link{sample.names}()},
\code{\link{sequences}()},
\code{\link{taxa.names}()},
\code{\link{taxa.ranks}()},
\code{\link{taxonomy}()}
}
\concept{accessor functions}
