% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tips.r
\name{tips}
\alias{tips}
\title{Names of a phylogenetic tree's tips/leafs.}
\usage{
tips(x)
}
\arguments{
\item{x}{A phylo object, as returned from \link{read.tree}..}
}
\value{
A character vector with the leaf names.
}
\description{
Names of a phylogenetic tree's tips/leafs.
}
\examples{
    library(rbiom)
    
    infile <- system.file("extdata", "newick.tre", package = "rbiom")
    tree <- read.tree(infile)
    
    leafs   <- tips(tree)
    subtree <- subtree(tree, head(leafs))

}
