% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbiom-package.R
\docType{package}
\name{rbiom-package}
\alias{rbiom}
\alias{rbiom-package}
\title{rbiom: Read/Write, Transform, and Summarize BIOM Data}
\description{
A toolkit for working with Biological Observation Matrix (BIOM) files.
Features include reading/writing all BIOM formats, rarefaction, alpha
diversity, beta diversity (including UniFrac), summarizing counts by
taxonomic level, and sample subsetting. Standalone functions for
reading, writing, and subsetting phylogenetic trees are also provided.
All CPU intensive operations are encoded in C with multi-thread support.
}
\section{Multithreading}{

Many rbiom functions support multithreading:

The default behavior of these function is to run on as many cores as are
available in the local compute environment. If you wish to limit the number
of simultaneous threads, set \code{RcppParallel}'s \code{numThreads} option.
For instance:

\preformatted{
    RcppParallel::setThreadOptions(numThreads = 4)
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://cmmr.github.io/rbiom/}
  \item \url{https://github.com/cmmr/rbiom}
  \item Report bugs at \url{https://github.com/cmmr/rbiom/issues}
}

}
\author{
\strong{Maintainer}: Daniel P. Smith \email{dansmith01@gmail.com} (\href{https://orcid.org/0000-0002-2479-2044}{ORCID})

Other contributors:
\itemize{
  \item Alkek Center for Metagenomics and Microbiome Research [copyright holder, funder]
}

}
\keyword{internal}
