% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_biom.r
\name{read_biom}
\alias{read_biom}
\title{Parse counts, metadata, taxonomy, and phylogeny from a BIOM file.}
\usage{
read_biom(src, ...)
}
\arguments{
\item{src}{Input data as either a file path, URL, or JSON string.
BIOM files can be formatted according to
version 1.0 (JSON) or 2.1 (HDF5)
\href{http://biom-format.org/documentation/}{specifications}, or as
classical tabular format. URLs must begin with \code{http://},
\code{https://}, \code{ftp://}, or \code{ftps://}. JSON files must
have \code{\{} as their first character. Compressed (gzip or bzip2)
BIOM files are also supported. NOTE: to read HDF5 formatted BIOM
files, the BioConductor R package \code{rhdf5} must be installed.}

\item{...}{Properties to set in the new rbiom object, for example,
\code{metadata}, \code{id}, \code{comment}, or \code{tree}.}
}
\value{
An \link[=rbiom_objects]{rbiom object}.
}
\description{
Parse counts, metadata, taxonomy, and phylogeny from a BIOM file.
}
\examples{
    library(rbiom)

    infile <- system.file("extdata", "hmp50.bz2", package = "rbiom")
    biom <- read_biom(infile)

    print(biom)

    # Taxa Abundances
    biom$counts[1:4,1:10] \%>\% as.matrix()
    
    biom$taxonomy \%>\% head()

    # Metadata
    biom$metadata \%>\% head()
    
    table(biom$metadata$Sex, biom$metadata$`Body Site`)
    
    sprintf("Mean age: \%.1f", mean(biom$metadata$Age))

    # Phylogenetic tree
    biom$tree \%>\%
      tree_subset(1:10) \%>\%
      plot()

}
\seealso{
\code{as_rbiom()}
}
