% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdiv_heatmap.r
\name{bdiv_heatmap}
\alias{bdiv_heatmap}
\title{Display beta diversities in an all vs all grid.}
\usage{
bdiv_heatmap(
  biom,
  bdiv = "Bray-Curtis",
  weighted = TRUE,
  tree = NULL,
  tracks = NULL,
  grid = "devon",
  label = TRUE,
  label_size = NULL,
  rescale = "none",
  clust = "complete",
  trees = TRUE,
  asp = 1,
  tree_height = 10,
  track_height = 10,
  legend = "right",
  title = TRUE,
  xlab.angle = "auto",
  underscores = FALSE,
  ...
)
}
\arguments{
\item{biom}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.
Any value accepted by \code{\link[=as_rbiom]{as_rbiom()}} can also be given here.}

\item{bdiv}{Beta diversity distance algorithm(s) to use. Options are:
\code{"Bray-Curtis"}, \code{"Manhattan"}, \code{"Euclidean"},
\code{"Jaccard"}, and \code{"UniFrac"}. For \code{"UniFrac"}, a
phylogenetic tree must be present in \code{biom} or explicitly
provided via \verb{tree=}. Multiple/abbreviated values allowed.
Default: \code{"Bray-Curtis"}}

\item{weighted}{Take relative abundances into account. When
\code{weighted=FALSE}, only presence/absence is considered.
Multiple values allowed. Default: \code{TRUE}}

\item{tree}{A \code{phylo} object representing the phylogenetic
relationships of the taxa in \code{biom}. Only required when
computing UniFrac distances. Default: \code{biom$tree}}

\item{tracks}{A character vector of metadata fields to display as tracks
at the top of the plot. Or, a list as expected by the \code{tracks}
argument of \code{\link[=plot_heatmap]{plot_heatmap()}}. Default: \code{NULL}}

\item{grid}{Color palette name, or a list with entries for \code{label},
\code{colors}, \code{range}, \code{bins}, \code{na.color}, and/or
\code{guide}. See the Track Definitions section for details.
Default: \code{"devon"}}

\item{label}{Label the matrix rows and columns. You can supply a list
or logical vector of length two to control row labels and column
labels separately, for example
\code{label = c(rows = TRUE, cols = FALSE)}, or simply
\code{label = c(TRUE, FALSE)}. Other valid options are \code{"rows"},
\code{"cols"}, \code{"both"}, \code{"bottom"}, \code{"right"},
and \code{"none"}.
Default: \code{TRUE}}

\item{label_size}{The font size to use for the row and column labels. You
can supply a numeric vector of length two to control row label sizes
and column label sizes separately, for example
\code{c(rows = 20, cols = 8)}, or simply \code{c(20, 8)}.
Default: \code{NULL}, which computes:
\code{pmax(8, pmin(20, 100 / dim(mtx)))}}

\item{rescale}{Rescale rows or columns to all have a common min/max.
Options: \code{"none"}, \code{"rows"}, or \code{"cols"}.
Default: \code{"none"}}

\item{clust}{Clustering algorithm for reordering the rows and columns by
similarity. You can supply a list or character vector of length two to
control the row and column clustering separately, for example
\code{clust = c(rows = "complete", cols = NA)}, or simply
\code{clust = c("complete", NA)}. Options are:
\describe{
\item{\code{FALSE} or \code{NA} - }{ Disable reordering. }
\item{An \code{hclust} class object}{ E.g. from \code{\link[stats:hclust]{stats::hclust()}}. }
\item{A method name - }{ \code{"ward.D"},
\code{"ward.D2"}, \code{"single"}, \code{"complete"},
\code{"average"}, \code{"mcquitty"}, \code{"median"}, or
\code{"centroid"}. }
}
Default: \code{"complete"}}

\item{trees}{Draw a dendrogram for rows (left) and columns (top). You can
supply a list or logical vector of length two to control the row tree
and column tree separately, for example
\code{trees = c(rows = TRUE, cols = FALSE)},
or simply \code{trees = c(TRUE, FALSE)}.
Other valid options are \code{"rows"}, \code{"cols"}, \code{"both"},
\code{"left"}, \code{"top"}, and \code{"none"}.
Default: \code{TRUE}}

\item{asp}{Aspect ratio (height/width) for entire grid.
Default: \code{1} (square)}

\item{tree_height, track_height}{The height of the dendrogram or annotation
tracks as a percentage of the overall grid size. Use a numeric vector
of length two to assign \code{c(top, left)} independently.
Default: \code{10} (10\% of the grid's height)}

\item{legend}{Where to place the legend. Options are: \code{"right"} or
\code{"bottom"}. Default: \code{"right"}}

\item{title}{Plot title. Set to \code{TRUE} for a default title, \code{NULL} for
no title, or any character string. Default: \code{TRUE}}

\item{xlab.angle}{Angle of the labels at the bottom of the plot.
Options are \code{"auto"}, \code{'0'}, \code{'30'}, and \code{'90'}.
Default: \code{"auto"}.}

\item{underscores}{When parsing the tree, should underscores be kept as
is? By default they will be converted to spaces (unless the entire ID
is quoted). Default \code{FALSE}}

\item{...}{Additional arguments to pass on to ggplot2::theme().
For example, \code{labs.subtitle = "Plot subtitle"}.}
}
\value{
A \code{ggplot2} plot. The computed data points and ggplot
command are available as \verb{$data} and \verb{$code},
respectively.
}
\description{
Display beta diversities in an all vs all grid.
}
\section{Annotation Tracks}{


Metadata can be displayed as colored tracks above the heatmap. Common use
cases are provided below, with more thorough documentation available at
https://cmmr.github.io/rbiom .

\preformatted{## Categorical ----------------------------
tracks = "Body Site"
tracks = list('Body Site' = "bright")
tracks = list('Body Site' = c('Stool' = "blue", 'Saliva' = "green"))

## Numeric --------------------------------
tracks = "Age"
tracks = list('Age' = "reds")

## Multiple Tracks ------------------------
tracks = c("Body Site", "Age")
tracks = list('Body Site' = "bright", 'Age' = "reds")
tracks = list(
  'Body Site' = c('Stool' = "blue", 'Saliva' = "green"),
  'Age'       = list('colors' = "reds") )
}

The following entries in the track definitions are understood:

\describe{
\item{\code{colors} - }{ A pre-defined palette name or custom set of colors to map to. }
\item{\code{range} - }{ The c(min,max) to use for scale values. }
\item{\code{label} - }{ Label for this track. Defaults to the name of this list element. }
\item{\code{side} - }{ Options are \code{"top"} (default) or \code{"left"}. }
\item{\code{na.color} - }{ The color to use for \code{NA} values. }
\item{\code{bins} - }{ Bin a gradient into this many bins/steps. }
\item{\code{guide} - }{ A list of arguments for guide_colorbar() or guide_legend(). }
}

All built-in color palettes are colorblind-friendly.

Categorical palette names: \code{"okabe"}, \code{"carto"}, \code{"r4"},
\code{"polychrome"}, \code{"tol"}, \code{"bright"}, \code{"light"},
\code{"muted"}, \code{"vibrant"}, \code{"tableau"}, \code{"classic"},
\code{"alphabet"}, \code{"tableau20"}, \code{"kelly"}, and \code{"fishy"}.

Numeric palette names: \code{"reds"}, \code{"oranges"}, \code{"greens"},
\code{"purples"}, \code{"grays"}, \code{"acton"}, \code{"bamako"},
\code{"batlow"}, \code{"bilbao"}, \code{"buda"}, \code{"davos"},
\code{"devon"}, \code{"grayC"}, \code{"hawaii"}, \code{"imola"},
\code{"lajolla"}, \code{"lapaz"}, \code{"nuuk"}, \code{"oslo"},
\code{"tokyo"}, \code{"turku"}, \code{"bam"}, \code{"berlin"},
\code{"broc"}, \code{"cork"}, \code{"lisbon"}, \code{"roma"},
\code{"tofino"}, \code{"vanimo"}, and \code{"vik"}.
}

\examples{
    library(rbiom)
    
    # Keep and rarefy the 10 most deeply sequenced samples.
    hmp10 <- rarefy(hmp50, n = 10)
    
    bdiv_heatmap(hmp10, tracks=c("Body Site", "Age"))
    
    bdiv_heatmap(hmp10, bdiv="uni", weighted=c(TRUE,FALSE), tracks="sex")
}
\seealso{
Other beta_diversity: 
\code{\link{bdiv_boxplot}()},
\code{\link{bdiv_clusters}()},
\code{\link{bdiv_corrplot}()},
\code{\link{bdiv_ord_plot}()},
\code{\link{bdiv_ord_table}()},
\code{\link{bdiv_stats}()},
\code{\link{bdiv_table}()},
\code{\link{distmat_stats}()}

Other visualization: 
\code{\link{adiv_boxplot}()},
\code{\link{adiv_corrplot}()},
\code{\link{bdiv_boxplot}()},
\code{\link{bdiv_corrplot}()},
\code{\link{bdiv_ord_plot}()},
\code{\link{plot_heatmap}()},
\code{\link{rare_corrplot}()},
\code{\link{rare_multiplot}()},
\code{\link{rare_stacked}()},
\code{\link{stats_boxplot}()},
\code{\link{stats_corrplot}()},
\code{\link{taxa_boxplot}()},
\code{\link{taxa_corrplot}()},
\code{\link{taxa_heatmap}()},
\code{\link{taxa_stacked}()}
}
\concept{beta_diversity}
\concept{visualization}
