% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BtcAddresses.R
\name{Wif2PrivKey}
\alias{Wif2PrivKey}
\title{Create private key from WIF}
\usage{
Wif2PrivKey(wif)
}
\arguments{
\item{wif}{\code{character}, a WIF key.}
}
\value{
\code{character}, the corresponding private key.
}
\description{
Returns the corresponding private key from a WIF key.
}
\examples{
pk1 <- createPrivateKey()
wif <- PrivKey2Wif(pk1)
pk2 <- Wif2PrivKey(wif)
identical(pk1, pk2)
}
\references{
\url{https://en.bitcoin.it/wiki/Wallet_import_format},\cr
\url{https://en.bitcoin.it/wiki/Address}
}
\seealso{
Other BtcAdresses: \code{\link{BTCADR-class}},
  \code{\link{PrivKey2PubKey}}, \code{\link{PrivKey2Wif}},
  \code{\link{PubHash2BtcAdr}},
  \code{\link{PubKey2PubHash}},
  \code{\link{base58CheckDecode}},
  \code{\link{base58CheckEncode}}, \code{\link{concatHex}},
  \code{\link{createBtcAdr}},
  \code{\link{createPrivateKey}}, \code{\link{decodeHex}},
  \code{\link{hash160}}, \code{\link{hash256}},
  \code{\link{validBtcAdr}}
}
\author{
Bernhard Pfaff
}
\concept{BtcAdresses}
