% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_zenith_raster_coordinates.R
\name{calc_zenith_raster_coordinates}
\alias{calc_zenith_raster_coordinates}
\title{Calculate zenith raster coordinates}
\usage{
calc_zenith_raster_coordinates(path_to_csv)
}
\arguments{
\item{path_to_csv}{Character vector of length one. Path to a CSV file created
with the
\href{https://imagej.nih.gov/ij/docs/guide/146-19.html#sec:Multi-point-Tool}{point
 selection tool of ‘ImageJ’ software}.}
}
\value{
Numeric vector of length two. Raster coordinates of the zenith,
  assuming a lens facing up with its optical axis parallel to the
  vertical line. It is important to note the difference between the raster
  coordinates and the Cartesian coordinates. In the latter,  the vertical
  axis value decreases down, but the opposite is true for the raster
  coordinates, which works like a spreadsheet.
}
\description{
Calculate zenith raster coordinates from points digitized with the
open-source software package ‘ImageJ’. The zenith is the point on the image
that represents the zenith when upward-looking photographs are taken with the
optical axis parallel to the vertical line.
}
\details{
The technique described under the headline ‘Optical center characterization’
of the
\href{https://www6.paca.inrae.fr/can-eye/content/download/3052/30819/version/4/file/CAN_EYE_User_Manual.pdf}{user
manual of the software Can-Eye} can be used to acquire the data for
determining the zenith coordinates. This technique was used by
\insertCite{Pekin2009;textual}{rcaiman}, among others. Briefly, it consists
in drilling a small hole in the cap of the fisheye lens (it must be away from
the center of the cap), and taking about ten photographs without removing the
cap. The cap must be rotated about 30º before taking each photograph.
\strong{The method implemented here do not support multiple holes}.

The
\href{https://imagej.nih.gov/ij/docs/guide/146-19.html#sec:Multi-point-Tool}{point
selection tool of ‘ImageJ’ software} should be used to manually digitize the
white dots and create a CSV file to feed this function.

Another method --only valid for circular hemispherical photographs-- is
taking a very bright picture (for example, a picture of a room with walls
painted in light colors) with the lens completely free (do not use any
mount). Then, digitize points over the perimeter of the circle. This was the
method used for producing the example (see below). It is worth noting that
the perimeter of the circle depicted in a circular hemispherical photograph
is not necessarily the horizon.
}
\examples{
\dontrun{
path <- system.file("external/points_over_perimeter.csv",
                    package = "rcaiman")
calc_zenith_raster_coordinates(path)
}
}
\references{
\insertAllCited{}
}
\seealso{
Other Lens functions: 
\code{\link{azimuth_image}()},
\code{\link{calc_diameter}()},
\code{\link{calibrate_lens}()},
\code{\link{expand_noncircular}()},
\code{\link{lens}()},
\code{\link{reproject_to_equidistant}()},
\code{\link{test_lens_coef}()},
\code{\link{zenith_image}()}
}
\concept{Lens functions}
