% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_sky_pixels.R
\name{find_sky_pixels}
\alias{find_sky_pixels}
\title{Find sky pixles}
\usage{
find_sky_pixels(r, z, a, no_of_samples = 30)
}
\arguments{
\item{r}{\linkS4class{RasterLayer}. A normalized greyscale image. Typically,
the blue channel extracted from an hemispherical photograph. Please see
\code{\link{read_caim}} and \code{\link{normalize}}.}

\item{z}{\linkS4class{RasterLayer}. The result of a call to
\code{\link{zenith_image}}.}

\item{a}{\linkS4class{RasterLayer}. The result of a call to
\code{\link{azimuth_image}}.}

\item{no_of_samples}{Numeric vector of length one. Minimum number of samples
required.}
}
\value{
An object of class \linkS4class{RasterLayer} with values \code{0} and
  \code{1}. This layer masks pixels that are very likely pure sky pixels.
}
\description{
Find sky pixels automatically
}
\details{
This function assumes that (1) there is at least one pure sky pixel at the
level of cells of \eqn{30 \times 30} degrees, and (2) sky pixels have a
digital number (DN) greater than canopy pixels have.

For each cell, it compute a quantile value and use it as a threshold to
select the pure sky pixels of the cell, which produce binarized image as a
result in a regional binarization fashion
(\code{\link{regional_thresholding}}). This process start with a quantile
probability of 0.99. After producing the binarized image, this function use a
search grid with cells of \eqn{5 \times 5} degrees to count how many cells on
the binarired image have at least one sky pixel. If the count does not reach
argument \code{no_of_samples}, it goes back to the binarization step but
decreasing the probability by 0.01 points.
}
\examples{
\dontrun{
path <- system.file("external/4_D_2_DSCN4502.JPG", package = "rcaiman")
caim <- read_caim(path, c(1280, 960) - 745, 745 * 2, 745 * 2)
z <- zenith_image(ncol(caim), lens("Nikon_FCE9"))
a <- azimuth_image(z)
blue <- gbc(caim$Blue)
bin <- find_sky_pixels(blue, z, a)
plot(bin)
}
}
\seealso{
Other MBLT functions: 
\code{\link{fit_coneshaped_model}()},
\code{\link{fit_trend_surface}()},
\code{\link{ootb_mblt}()},
\code{\link{thr_image}()}
}
\concept{MBLT functions}
