% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regional_thresholding.R
\name{regional_thresholding}
\alias{regional_thresholding}
\title{Regional thresholding}
\usage{
regional_thresholding(
  r,
  segmentation,
  method,
  intercept = NULL,
  slope = NULL,
  prob = NULL
)
}
\arguments{
\item{r}{\linkS4class{RasterLayer}. Normalized greyscale image. See
\code{\link{normalize}} and \code{\link{gbc}}}

\item{segmentation}{\linkS4class{RasterLayer}. The result of segmenting
\code{r}. Probably, \code{\link{rings_segmentation}} will be the most used
for fisheye images.}

\item{method}{Character vector of length one. See details for current
options.}

\item{intercept}{Numeric vector of length one. These are linear
function coefficients. Please, see the Details section of
\code{\link{thr_image}}.}

\item{slope}{Numeric vector of length one. These are linear
function coefficients. Please, see the Details section of
\code{\link{thr_image}}.}

\item{prob}{Logical vector of length one. Probability for
\code{\link[stats]{quantile}} calculation. See reference
\insertCite{Diaz2018;textual}{rcaiman}.}
}
\value{
An object of class \linkS4class{RasterLayer} with values \code{0} and
  \code{1}.
}
\description{
Regional thresholding of greyscale images
}
\details{
Methods currently implemented are:

\itemize{ \item \strong{Diaz2018}: method presented in
\insertCite{Diaz2018;textual}{rcaiman} applied regionally. If this method is
selected, the arguments \code{intercept}, \code{slope}, and \code{prob}
should be provided. It works segmentwise extracting the digital numbers (dns)
per segment and passing them to \code{quantile(dns, prob)}, which aggregated
result (x) is in turn passed to \code{thr_image(x, intercept, slope)}.
Finally, this threshold image is applied to obtain a binarized image.

\item \strong{Methods from autothresholdr package}: this function can call
methods from \code{\link[autothresholdr]{auto_thresh}}. Use \code{"IsoData"}
to use the algorithm by \insertCite{isodata;textual}{rcaiman}, which is the one
recommended by \insertCite{Jonckheere2005;textual}{rcaiman}. }
}
\examples{
r <- read_caim()
blue <- gbc(r$Blue)
z <- zenith_image(ncol(r), lens("Nikon_FCE9"))
rings <- rings_segmentation(z, 10)
bin <- regional_thresholding(blue, rings, "Diaz2018", -8, 0.5, 0.9)
plot(bin) # gross errors near the horizon, try ootb_mblt()
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{thr_image}}

Other Tools functions: 
\code{\link{apply_thr}()},
\code{\link{extract_feature}()},
\code{\link{gbc}()},
\code{\link{masking}()},
\code{\link{normalize}()},
\code{\link{read_bin}()},
\code{\link{read_caim}()},
\code{\link{write_bin}()},
\code{\link{write_caim}()}
}
\concept{Tools functions}
