% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregation.R
\name{stkde}
\alias{stkde}
\title{Map the spatio-temporal intensity of a set of radiocarbon dates}
\usage{
stkde(x, coords, sbw, focalyears, tbw, win, cellres, outdir = ".",
  bins = NA, backsight = NA, maskthresh = 0,
  changexpr = expression((t1 - t0)/tk), spjitter = TRUE,
  amount = NULL, verbose = TRUE, ...)
}
\arguments{
\item{x}{An object of class CalDates with calibrated radiocarbon ages.}

\item{coords}{A two column matrix of geographical coordinates from a a projected coordinate system (no checks are made for this) and with the same number of rows as length(x).}

\item{sbw}{A single numeric value for the spatial bandwidth to be applied around each raster cell, expressed as the standard deviation of a continuous Gaussian kernel (passed as the sigma argument to density.ppp()).}

\item{focalyears}{A vector of numeric values for focal years, in calBP, that will be timesteps at which date intensity maps will be produced.}

\item{tbw}{A single numeric value for the temporal bandwidth to be applied around each focal year, expressed as the standard deviation of a continuous Gaussian kernel.}

\item{win}{The bounding polygon for the mapping (must be an object of class 'owin', see the spatstat package)}

\item{cellres}{The cell or pixel resolution of the output raster maps.}

\item{outdir}{The output directory for timeslice maps and data that are saved to file.}

\item{bins}{A vector of labels corresponding to site names, ids, bins or phases (same length as x)}

\item{backsight}{A single numeric value (which will be coerced to be positive) that specifies a comparison timestep in the past for a mapping of temporal change.}

\item{maskthresh}{A single numeric value for a lower-bound cut-off for all maps, based on a minimum required spatial intensity of all dates in x.}

\item{changexpr}{An expression for calculating the change in spatial intensity between the focal year and a backsight year (as defined via the backsight argument). Available input options are t1 (the spatial intensity for the focal year), t0 (the spatial intensity for the backsight year) and tk (the overall spatial intensity for all dates irrespective of year), plus any other standard constants and mathematical operators. A sensible default is provided.}

\item{spjitter}{Whether noise is applied to the spatial coordinates or not. Default is TRUE.}

\item{amount}{Amount of jitter applied to the spatial coordinates when \code{spjitter=TRUE}. Default is d/5, where d is difference between the closest coordinates.}

\item{verbose}{A logical variable indicating whether extra information on progress should be reported. Default is TRUE.}

\item{...}{ignored or passed to internal functions.}
}
\value{
A list object of class stKde with the following elements:
\itemize{
\item {A series of list items storing some of the input parameters such as the focalyears, sbw, tbw, backsight, maskthresh} 
\item{\code{nonfocal}} {An im object mapping the basic spatial intensity of all dates, without reference to a focal year.} 
\item{\code{impaths}} {A character vector of the paths to the individual timeslices stored on file. Maps are not stored in memory (see spkde() for further details of what is stored).}
\item{\code{stats}} {A list of data.frames offering summary statistics on each of the different types of output surface across all timeslices. Used primarily to allow consistent colour ramps across time-slices.}
\item{\code{ppp}} {The ppp object for all dates and the observation window.}
}
}
\description{
Function for mapping the spatio-temporal intensity of radiocarbon dates for a given geographical region in one or more tim.
}
\details{
This function computes one or more timeslice maps of the spatio-temporal kernel intensity of radiocarbon dates across a geographic region and for a specific focal year. The user specifies the arbitrary sizes of both the spatial and the temporal Gaussian kernels that will be used to summarise radiocarbon date intensity per grid cell per timestep. The results allow standardisation of colour ramps, etc. across timesteps and are amenable to plotting individually via plot.stKde and/or for output to png for animation.
}
\examples{
\dontrun{
## Example with a subset of English and Welsh dates from the Euroevol dataset
data(ewdates)
data(ewowin)
x <- calibrate(x=ewdates$C14Age, errors=ewdates$C14SD, normalised=FALSE)
## Create centennial timeslices (also with site binning)
bins1 <- binPrep(sites=ewdates$SiteID, ages=ewdates$C14Age, h=50)
stkde1 <- stkde(x=x, coords=ewdates[,c("Eastings", "Northings")], win=ewowin, 
sbw=40000, cellres=2000, focalyears=seq(6500, 5000, -100), tbw=50, bins=bins1, 
backsight=200, outdir="im",amount=1)
## Plot an example of all four basic outputs for 5900 calBP
dev.new(height=2.5, width=8)
par(mar=c(0.5, 0.5, 2.5, 2))
plot(stkde1, 5900, type="all")
}

}
