% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{runMean}
\alias{runMean}
\title{Calculate a running mean from a numeric vector.}
\usage{
runMean(x, n, edge = "NA")
}
\arguments{
\item{x}{numeric vector to smooth.}

\item{n}{the size of the window in which to smooth.}

\item{edge}{How to treat edge cases where a full window is unavailable. Current options are 'NA' to fill with NAs or 'fill' to fill with original values}
}
\value{
A numeric vector of smoothed values.
}
\description{
Calculate a running mean from a numeric vector.
}
\examples{
x <- rnorm(1000)
y <- c(1:1000)
plot(y,x, type="l")
lines(runMean(x,50), col="red")
}
