/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import javax.vecmath.Point2d;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.applications.jchempaint.DrawingPanel;
import org.openscience.cdk.applications.jchempaint.InsertTextPanel;
import org.openscience.cdk.applications.jchempaint.JCPLocalizationHandler;
import org.openscience.cdk.applications.jchempaint.JCPPropertyHandler;
import org.openscience.cdk.applications.jchempaint.JChemPaintEditorPanel;
import org.openscience.cdk.applications.jchempaint.JChemPaintMenuBar;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.JChemPaintViewerOnlyPanel;
import org.openscience.cdk.applications.jchempaint.StatusBar;
import org.openscience.cdk.applications.jchempaint.StringHelper;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.jchempaint.action.SaveAction;
import org.openscience.cdk.applications.jchempaint.dialogs.CreateCoordinatesForFileDialog;
import org.openscience.cdk.applications.plugin.ICDKEditBus;
import org.openscience.cdk.applications.undoredo.ClearAllEdit;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.ReaderFactory;
import org.openscience.cdk.io.listener.IChemObjectIOListener;
import org.openscience.cdk.io.listener.SwingGUIListener;
import org.openscience.cdk.renderer.Renderer2DModel;
import org.openscience.cdk.tools.LoggingTool;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public abstract class JChemPaintPanel
extends JPanel
implements ChangeListener,
ICDKEditBus {
    boolean isEmbedded = false;
    boolean isOpenedByViewer = false;
    boolean isViewerOnly = false;
    static Vector instances = new Vector();
    protected JChemPaintModel jchemPaintModel;
    private LoggingTool logger;
    private File currentWorkDirectory = null;
    private File lastOpenedFile = null;
    private File lastSavedFile = null;
    private FileFilter currentOpenFileFilter = null;
    private FileFilter currentSaveFileFilter = null;
    JPanel mainContainer;
    JPanel topContainer;
    StatusBar statusBar;
    JChemPaintMenuBar menu;
    JToolBar toolBar;
    InsertTextPanel insertTextPanel = null;
    DrawingPanel drawingPanel;
    public JButton selectButton;
    JCPAction jcpaction = null;
    protected File isAlreadyAFile = null;
    public JChemPaintPanel lastUsedJCPP = null;
    public Vector lastAction = new Vector();
    Dimension viewerDimension;
    String guiString = "stable";
    protected JButton moveButton = null;
    private JScrollPane scrollPane;
    static /* synthetic */ Class class$org$openscience$cdk$ChemFile;
    static /* synthetic */ Class class$org$openscience$cdk$ChemModel;
    static /* synthetic */ Class class$java$awt$event$WindowListener;

    public JChemPaintPanel() {
        this.logger = new LoggingTool((Object)this);
        this.setLayout(new BorderLayout());
        this.mainContainer = new JPanel(new BorderLayout());
        this.topContainer = new JPanel(new BorderLayout());
        this.drawingPanel = new DrawingPanel();
        this.drawingPanel.setOpaque(true);
        this.drawingPanel.setBackground(Color.white);
        this.scrollPane = new JScrollPane(this.drawingPanel, 20, 30);
        this.mainContainer.add((Component)this.scrollPane, "Center");
        this.mainContainer.add((Component)this.topContainer, "North");
        this.add((Component)this.mainContainer, "Center");
        this.setSize(new Dimension(900, 400));
        this.setPreferredSize(new Dimension(900, 400));
        instances.add(this);
    }

    public JCPAction getJCPAction() {
        if (this.jcpaction == null) {
            this.jcpaction = new JCPAction();
        }
        return this.jcpaction;
    }

    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    public boolean isViewerOnly() {
        return this.isViewerOnly;
    }

    public void setEmbedded() {
        this.isEmbedded = true;
    }

    public boolean getIsOpenedByViewer() {
        return this.isOpenedByViewer;
    }

    public void setIsOpenedByViewer(boolean isOpenedByViewer) {
        this.isOpenedByViewer = isOpenedByViewer;
    }

    public void setViewerOnly() {
        this.isEmbedded = true;
        this.isViewerOnly = true;
    }

    public void setNotEmbedded() {
        this.isEmbedded = false;
    }

    public Vector getInstances() {
        return instances;
    }

    public void setIsAlreadyAFile(File value) {
        this.isAlreadyAFile = value;
    }

    public File isAlreadyAFile() {
        return this.isAlreadyAFile;
    }

    public static String getNewFrameName() {
        return JCPLocalizationHandler.getInstance().getString("Untitled-") + Integer.toString(instances.size() + 1);
    }

    public Image takeSnapshot() {
        return null;
    }

    public File getCurrentWorkDirectory() {
        return this.currentWorkDirectory;
    }

    public void setCurrentWorkDirectory(File cwd) {
        this.currentWorkDirectory = cwd;
    }

    public FileFilter getCurrentOpenFileFilter() {
        return this.currentOpenFileFilter;
    }

    public void setCurrentOpenFileFilter(FileFilter ff) {
        this.currentOpenFileFilter = ff;
    }

    public FileFilter getCurrentSaveFileFilter() {
        return this.currentSaveFileFilter;
    }

    public void setCurrentSaveFileFilter(FileFilter ff) {
        this.currentSaveFileFilter = ff;
    }

    public File getLastOpenedFile() {
        return this.lastOpenedFile;
    }

    public void setLastOpenedFile(File lof) {
        this.lastOpenedFile = lof;
    }

    public File getLastSavedFile() {
        return this.lastSavedFile;
    }

    public void setLastSavedFile(File lsf) {
        this.lastSavedFile = lsf;
    }

    public void setJChemPaintModel(JChemPaintModel model) {
        this.lastUsedJCPP = this;
        if (model != null && this.jchemPaintModel != null && model.getChemModel().getMoleculeSet() != null) {
            model.getRendererModel().setBackgroundDimension(this.jchemPaintModel.getRendererModel().getBackgroundDimension());
            IAtomContainer acc = ChemModelManipulator.getAllInOneContainer((IChemModel)model.getChemModel());
            Dimension molDim = GeometryTools.get2DDimension((IAtomContainer)acc, (HashMap)model.getRendererModel().getRenderingCoordinates());
            if (this.isViewerOnly) {
                Dimension viewerDim = null;
                try {
                    viewerDim = this.getViewerDimension();
                }
                catch (ClassCastException cce) {
                    // empty catch block
                }
                if (viewerDim != null) {
                    model.getRendererModel().setBackgroundDimension(viewerDim);
                }
            }
            Dimension backDim = model.getRendererModel().getBackgroundDimension();
            int height = (int)backDim.getHeight();
            int width = (int)backDim.getWidth();
            if (molDim.getHeight() >= backDim.getHeight()) {
                height = (int)molDim.getHeight() + 10;
            } else if (molDim.getWidth() >= backDim.getWidth()) {
                width = (int)molDim.getWidth() + 10;
            }
            model.getRendererModel().setBackgroundDimension(new Dimension(width, height));
        } else if (model.getChemModel().getMoleculeSet() == null && this.isViewerOnly) {
            Dimension viewerDim = null;
            try {
                viewerDim = this.getViewerDimension();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (viewerDim != null) {
                model.getRendererModel().setBackgroundDimension(viewerDim);
            }
        }
        if (this.jchemPaintModel != null && this.jchemPaintModel.getControllerModel() != null) {
            model.getControllerModel().setAutoUpdateImplicitHydrogens(this.jchemPaintModel.getControllerModel().getAutoUpdateImplicitHydrogens());
        }
        if (this.jchemPaintModel != null && this.jchemPaintModel.getRendererModel() != null) {
            model.getRendererModel().setUseAntiAliasing(this.jchemPaintModel.getRendererModel().getUseAntiAliasing());
            model.getRendererModel().setShowImplicitHydrogens(this.jchemPaintModel.getRendererModel().getShowImplicitHydrogens());
            model.getRendererModel().setShowEndCarbons(this.jchemPaintModel.getRendererModel().getShowEndCarbons());
            model.getRendererModel().setShowAromaticityInCDKStyle(this.jchemPaintModel.getRendererModel().getShowAromaticityInCDKStyle());
            model.getRendererModel().setDrawNumbers(this.jchemPaintModel.getRendererModel().getDrawNumbers());
            model.getRendererModel().setShowAtomAtomMapping(this.jchemPaintModel.getRendererModel().getShowAtomAtomMapping());
            model.getRendererModel().setKekuleStructure(this.jchemPaintModel.getRendererModel().getKekuleStructure());
            model.getRendererModel().setColorAtomsByType(this.jchemPaintModel.getRendererModel().getColorAtomsByType());
            model.getRendererModel().setShowTooltip(this.jchemPaintModel.getRendererModel().getShowTooltip());
            model.getRendererModel().setShowReactionBoxes(this.jchemPaintModel.getRendererModel().getShowReactionBoxes());
        }
        this.jchemPaintModel = model;
        this.jchemPaintModel.addChangeListener(this);
        IChemModel chemModel = model.getChemModel();
        this.scaleAndCenterMolecule(chemModel);
        this.drawingPanel.setJChemPaintModel(model);
    }

    public String[] tokenize(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)v.elementAt(i);
        }
        return cmd;
    }

    public void showChemFile(Reader file) {
        IChemObjectReader cor = null;
        try {
            cor = this.getChemObjectReader(file);
        }
        catch (IOException ioExc) {
            this.logger.warn((Object)"IOException while determining file format.");
            this.logger.debug((Object)ioExc);
        }
        catch (Exception exc) {
            this.logger.warn((Object)"Exception while determining file format.");
            this.logger.debug((Object)exc);
        }
        if (cor == null) {
            JOptionPane.showMessageDialog(this, "Could not determine file format.");
            return;
        }
        String error = null;
        ChemFile chemFile = null;
        ChemModel chemModel = null;
        if (cor.accepts(class$org$openscience$cdk$ChemFile == null ? (class$org$openscience$cdk$ChemFile = JChemPaintPanel.class$("org.openscience.cdk.ChemFile")) : class$org$openscience$cdk$ChemFile)) {
            try {
                chemFile = (ChemFile)cor.read((IChemObject)new ChemFile());
                if (chemFile != null) {
                    this.processChemFile((IChemFile)chemFile);
                    return;
                }
                this.logger.warn((Object)"The object chemFile was empty unexpectedly!");
            }
            catch (Exception exception) {
                error = "Error while reading file: " + exception.getMessage();
                this.logger.warn((Object)error);
                this.logger.debug((Object)exception);
            }
        }
        if (error != null) {
            JOptionPane.showMessageDialog(this, error);
            return;
        }
        if (cor.accepts(class$org$openscience$cdk$ChemModel == null ? (class$org$openscience$cdk$ChemModel = JChemPaintPanel.class$("org.openscience.cdk.ChemModel")) : class$org$openscience$cdk$ChemModel)) {
            try {
                chemModel = (ChemModel)cor.read((IChemObject)new ChemModel());
                if (chemModel != null) {
                    this.processChemModel((IChemModel)chemModel);
                    return;
                }
                this.logger.warn((Object)"The object chemModel was empty unexpectedly!");
                error = null;
            }
            catch (Exception exception) {
                error = "Error while reading file: " + exception.getMessage();
                this.logger.error((Object)error);
                this.logger.debug((Object)exception);
            }
        }
        if (error != null) {
            JOptionPane.showMessageDialog(this, error);
        }
    }

    public JChemPaintModel getJChemPaintModel() {
        return this.jchemPaintModel;
    }

    public int showWarning() {
        if (this.jchemPaintModel.isModified() && !this.getIsOpenedByViewer() && !this.guiString.equals("applet")) {
            int answer = JOptionPane.showConfirmDialog(this, this.jchemPaintModel.getTitle() + " " + JCPLocalizationHandler.getInstance().getString("warning"), JCPLocalizationHandler.getInstance().getString("warningheader"), 1, 2);
            if (answer == 0) {
                new SaveAction(this, false).actionPerformed(new ActionEvent(this, 12, ""));
            }
            return answer;
        }
        if (this.guiString.equals("applet")) {
            ClearAllEdit coa = null;
            try {
                coa = new ClearAllEdit(this.getChemModel(), (IMoleculeSet)this.getChemModel().getMoleculeSet().clone(), this.getChemModel().getReactionSet());
                this.jchemPaintModel.getControllerModel().getUndoSupport().postEdit((UndoableEdit)coa);
            }
            catch (Exception e) {
                this.logger.error((Object)"Clone of IMoleculeSet failed: ", (Object)e.getMessage());
                this.logger.debug((Object)e);
            }
            return 0;
        }
        return 0;
    }

    public void processChemFile(IChemFile chemFile) {
        this.logger.info((Object)"Information read from file:");
        int chemSequenceCount = chemFile.getChemSequenceCount();
        this.logger.info((Object)"  # sequences: ", chemSequenceCount);
        for (int i = 0; i < chemSequenceCount; ++i) {
            IChemSequence chemSequence = chemFile.getChemSequence(i);
            int chemModelCount = chemSequence.getChemModelCount();
            this.logger.info((Object)("  # model in seq(" + i + "): "), chemModelCount);
            for (int j = 0; j < chemModelCount; ++j) {
                IChemModel chemModel = chemSequence.getChemModel(j);
                this.processChemModel(chemModel);
            }
        }
    }

    public void scaleAndCenterMolecule(IChemModel chemModel) {
        this.scaleAndCenterMolecule(chemModel, null);
    }

    public void scaleAndCenterMolecule(IChemModel chemModel, Dimension dim) {
        IAtomContainer ac = ChemModelManipulator.getAllInOneContainer((IChemModel)chemModel);
        this.scaleAndCenterMolecule(ac, dim);
    }

    public void scaleAndCenterMolecule(IAtomContainer ac, Dimension dim) {
        ((JViewport)this.drawingPanel.getParent()).setViewPosition(new Point((this.drawingPanel.getWidth() - this.getWidth()) / 2 > 0 ? (this.drawingPanel.getWidth() - this.getWidth()) / 2 : 0, (this.drawingPanel.getHeight() - this.getHeight()) / 2 > 0 ? (this.drawingPanel.getHeight() - this.getHeight()) / 2 : 0));
        JChemPaintModel jcpm = this.getJChemPaintModel();
        Renderer2DModel rendererModel = jcpm.getRendererModel();
        double scaleFactor = GeometryTools.getScaleFactor((IAtomContainer)ac, (double)rendererModel.getBondLength(), (HashMap)this.jchemPaintModel.getRendererModel().getRenderingCoordinates());
        GeometryTools.scaleMolecule((IAtomContainer)ac, (double)scaleFactor, (HashMap)this.jchemPaintModel.getRendererModel().getRenderingCoordinates());
        Rectangle view = ((JViewport)this.drawingPanel.getParent()).getViewRect();
        double x = view.getX() + view.getWidth();
        double y = view.getY() + view.getHeight();
        Renderer2DModel model = this.jchemPaintModel.getRendererModel();
        double relocatedY = model.getBackgroundDimension().getSize().getHeight() - (y + view.getY() / 2.0);
        double relocatedX = view.getX() / 2.0;
        Dimension viewablePart = new Dimension((int)x, (int)y);
        if (this instanceof JChemPaintViewerOnlyPanel) {
            GeometryTools.center((IAtomContainer)ac, (Dimension)model.getBackgroundDimension(), (HashMap)this.jchemPaintModel.getRendererModel().getRenderingCoordinates());
            relocatedX = 0.0;
            relocatedY = 0.0;
        } else if (dim == null) {
            if (viewablePart.getWidth() == 0.0 && viewablePart.getHeight() == 0.0) {
                relocatedX = 0.0;
                relocatedY = 0.0;
                GeometryTools.center((IAtomContainer)ac, (Dimension)model.getBackgroundDimension(), (HashMap)this.jchemPaintModel.getRendererModel().getRenderingCoordinates());
            } else {
                GeometryTools.center((IAtomContainer)ac, (Dimension)viewablePart, (HashMap)this.jchemPaintModel.getRendererModel().getRenderingCoordinates());
            }
        } else {
            relocatedY = model.getBackgroundDimension().getSize().getHeight() - dim.getHeight();
            relocatedX = 0.0;
            GeometryTools.center((IAtomContainer)ac, (Dimension)dim, (HashMap)this.jchemPaintModel.getRendererModel().getRenderingCoordinates());
        }
        Iterator atoms = ac.atoms();
        while (atoms.hasNext()) {
            IAtom atom = (IAtom)atoms.next();
            if (this.jchemPaintModel.getRendererModel().getRenderingCoordinate(atom) == null) continue;
            this.jchemPaintModel.getRendererModel().setRenderingCoordinate(atom, new Point2d(this.jchemPaintModel.getRendererModel().getRenderingCoordinate((IAtom)atom).x + relocatedX, this.jchemPaintModel.getRendererModel().getRenderingCoordinate((IAtom)atom).y + relocatedY));
        }
    }

    public void processChemModel(IChemModel chemModel) {
        if (ChemModelManipulator.getAllInOneContainer((IChemModel)chemModel).getBondCount() == 0) {
            String error = "Model does not have bonds. Cannot depict contents.";
            this.logger.warn((Object)error);
            JOptionPane.showMessageDialog(this, error);
            return;
        }
        if (GeometryTools.has2DCoordinatesNew((IAtomContainer)ChemModelManipulator.getAllInOneContainer((IChemModel)chemModel)) == 0) {
            String error = "Model does not have 2D coordinates. Cannot open file.";
            this.logger.warn((Object)error);
            JOptionPane.showMessageDialog(this, error);
            CreateCoordinatesForFileDialog frame = new CreateCoordinatesForFileDialog(chemModel, this.jchemPaintModel.getRendererModel().getRenderingCoordinates());
            frame.pack();
            frame.show();
            return;
        }
        if (GeometryTools.has2DCoordinatesNew((IAtomContainer)ChemModelManipulator.getAllInOneContainer((IChemModel)chemModel)) == 0) {
            int result = JOptionPane.showConfirmDialog(this, "Model has some 2d coordinates. Do you want to show only the atoms with 2d coordiantes?", "Only some 2d cooridantes", 0);
            if (result > 1) {
                CreateCoordinatesForFileDialog frame = new CreateCoordinatesForFileDialog(chemModel, this.jchemPaintModel.getRendererModel().getRenderingCoordinates());
                frame.pack();
                frame.show();
                return;
            }
            for (int i = 0; i < chemModel.getMoleculeSet().getAtomContainerCount(); ++i) {
                int k = 0;
                while (i < chemModel.getMoleculeSet().getAtomContainer(i).getAtomCount()) {
                    if (chemModel.getMoleculeSet().getAtomContainer(i).getAtom(k).getPoint2d() == null) {
                        chemModel.getMoleculeSet().getAtomContainer(i).removeAtomAndConnectedElectronContainers(chemModel.getMoleculeSet().getAtomContainer(i).getAtom(k));
                    }
                    ++k;
                }
            }
        }
        JChemPaintModel jcpm = new JChemPaintModel(chemModel);
        this.lastUsedJCPP = this;
        if (this.isEmbedded()) {
            if (this.showWarning() != 2) {
                this.registerModel(jcpm);
                this.setJChemPaintModel(jcpm);
                this.repaint();
            }
        } else if (this.getJChemPaintModel().getChemModel().getMoleculeSet() == null || this.getJChemPaintModel().getChemModel().getReactionSet() == null) {
            this.registerModel(jcpm);
            this.setJChemPaintModel(jcpm);
            this.repaint();
        } else {
            JFrame jcpf = JChemPaintEditorPanel.getNewFrame(jcpm);
            jcpf.setVisible(true);
            this.scaleAndCenterMolecule(chemModel);
            jcpf.pack();
            this.lastUsedJCPP = (JChemPaintPanel)jcpf.getContentPane().getComponents()[0];
        }
    }

    public IChemObjectReader getChemObjectReader(Reader reader) throws IOException {
        ReaderFactory factory = new ReaderFactory();
        IChemObjectReader coReader = factory.createReader(reader);
        if (coReader != null) {
            coReader.addChemObjectIOListener((IChemObjectIOListener)new SwingGUIListener((Component)this, 4));
        }
        return coReader;
    }

    public void showChemFile(IChemFile chemFile) {
        this.logger.info((Object)"Information read from file:");
        int chemSequenceCount = chemFile.getChemSequenceCount();
        this.logger.info((Object)("  # sequences: " + chemSequenceCount));
        for (int i = 0; i < chemSequenceCount; ++i) {
            IChemSequence chemSequence = chemFile.getChemSequence(i);
            int chemModelCount = chemSequence.getChemModelCount();
            this.logger.info((Object)("  # model in seq(" + i + "): " + chemModelCount));
            for (int j = 0; j < chemModelCount; ++j) {
                IChemModel chemModel = chemSequence.getChemModel(j);
                this.showChemModel(chemModel);
            }
        }
    }

    public void showChemModel(IChemModel chemModel) {
        if (ChemModelManipulator.getAllInOneContainer((IChemModel)chemModel).getBondCount() == 0) {
            String error = "Model does not have bonds. Cannot depict contents.";
            this.logger.warn((Object)error);
            JOptionPane.showMessageDialog(this, error);
            return;
        }
        if (GeometryTools.has2DCoordinatesNew((IAtomContainer)ChemModelManipulator.getAllInOneContainer((IChemModel)chemModel)) != 0) {
            String error = "Model does not have coordinates. Will ask for coord generation.";
            this.logger.warn((Object)error);
            CreateCoordinatesForFileDialog frame = new CreateCoordinatesForFileDialog((IChemModel)((ChemModel)chemModel), this.jchemPaintModel.getRendererModel().getRenderingCoordinates());
            frame.pack();
            frame.show();
            frame.moveToFront();
            return;
        }
        if (GeometryTools.has2DCoordinatesNew((IAtomContainer)ChemModelManipulator.getAllInOneContainer((IChemModel)chemModel)) == 0) {
            int result = JOptionPane.showConfirmDialog(this, "Model has some 2d coordinates. Do you want to show only the atoms with 2d coordiantes?", "Only some 2d cooridantes", 0);
            if (result > 1) {
                CreateCoordinatesForFileDialog frame = new CreateCoordinatesForFileDialog(chemModel, this.jchemPaintModel.getRendererModel().getRenderingCoordinates());
                frame.pack();
                frame.show();
                return;
            }
            for (int i = 0; i < chemModel.getMoleculeSet().getAtomContainerCount(); ++i) {
                int k = 0;
                while (i < chemModel.getMoleculeSet().getAtomContainer(i).getAtomCount()) {
                    if (chemModel.getMoleculeSet().getAtomContainer(i).getAtom(k).getPoint2d() == null) {
                        chemModel.getMoleculeSet().getAtomContainer(i).removeAtomAndConnectedElectronContainers(chemModel.getMoleculeSet().getAtomContainer(i).getAtom(k));
                    }
                    ++k;
                }
            }
        }
        this.setJChemPaintModel(new JChemPaintModel((IChemModel)((ChemModel)chemModel)));
    }

    public IChemModel getChemModel() {
        return this.jchemPaintModel.getChemModel();
    }

    public IChemFile getChemFile() {
        ChemFile file = new ChemFile();
        ChemSequence sequence = new ChemSequence();
        sequence.addChemModel(this.getChemModel());
        file.addChemSequence((IChemSequence)sequence);
        return file;
    }

    public JMenu getMenuForEmbedded() {
        return this.menu.getMenuForEmbedded(this);
    }

    public JPanel getDrawingPanel() {
        return this.drawingPanel;
    }

    public String getMenuResourceString(String key) {
        String str;
        try {
            str = JCPPropertyHandler.getInstance().getGUIDefinition().getString(key);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    public void addFilePopUpMenu() {
        if (this.guiString.equals("applet")) {
            return;
        }
        String key = "popupmenubar";
        String[] itemKeys = StringHelper.tokenize(this.getMenuResourceString(key));
        JPopupMenu popupMenu = new JPopupMenu();
        for (int i = 0; i < itemKeys.length; ++i) {
            String cmd = itemKeys[i];
            if (cmd.equals("-")) {
                popupMenu.addSeparator();
                continue;
            }
            String translation = "***" + cmd + "***";
            try {
                translation = JCPLocalizationHandler.getInstance().getString(cmd);
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
            JMenuItem mi = new JMenuItem(translation);
            String astr = JCPPropertyHandler.getInstance().getResourceString(cmd + "Action");
            if (astr == null) {
                astr = cmd;
            }
            mi.setActionCommand(astr);
            JCPAction action = this.getJCPAction().getAction(this, astr);
            if (action != null) {
                mi.setEnabled(action.isEnabled());
                mi.addActionListener(action);
            } else {
                this.logger.error((Object)("Could not find JCPAction class for:" + astr));
                mi.setEnabled(false);
            }
            popupMenu.add(mi);
        }
        this.getDrawingPanel().add(popupMenu);
        PopupListener popupListener = new PopupListener(this, popupMenu);
        this.getDrawingPanel().addMouseListener(popupListener);
    }

    public static void closeAllInstances() {
        Iterator it = instances.iterator();
        while (it.hasNext()) {
            JFrame frame = (JFrame)((JPanel)it.next()).getParent().getParent().getParent().getParent();
            WindowListener[] wls = (WindowListener[])frame.getListeners(class$java$awt$event$WindowListener == null ? JChemPaintPanel.class$("java.awt.event.WindowListener") : class$java$awt$event$WindowListener);
            wls[0].windowClosing(new WindowEvent(frame, 12));
            frame.setVisible(false);
            frame.dispose();
        }
    }

    public void registerModel(JChemPaintModel model) {
    }

    public void stateChanged(ChangeEvent e) {
        this.repaint();
    }

    public String getAPIVersion() {
        return "1.11";
    }

    public void runScript(String mimeType, String script) {
        this.logger.error((Object)"JChemPaintPanel's CDKEditBus.runScript() implementation called but not implemented!");
    }

    public Dimension getViewerDimension() {
        return this.viewerDimension;
    }

    public void setViewerDimension(Dimension viewerDimension) {
        this.viewerDimension = viewerDimension;
    }

    public UndoManager getUndoManager() {
        return this.jchemPaintModel.getControllerModel().getUndoManager();
    }

    public void setUndoManager(UndoManager undoManager) {
        this.jchemPaintModel.getControllerModel().setUndoManager(undoManager);
    }

    public UndoableEditSupport getUndoSupport() {
        return this.jchemPaintModel.getControllerModel().getUndoSupport();
    }

    public void setUndoSupport(UndoableEditSupport undoSupport) {
        this.jchemPaintModel.getControllerModel().setUndoSupport(undoSupport);
    }

    public JButton getMoveButton() {
        return this.moveButton;
    }

    public void setMoveButton(JButton moveButton) {
        this.moveButton = moveButton;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void setScrollPane(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class AppCloser
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            int clear;
            JFrame rootFrame = (JFrame)e.getSource();
            if (rootFrame.getContentPane().getComponent(0) instanceof JChemPaintEditorPanel) {
                JChemPaintEditorPanel panel = (JChemPaintEditorPanel)rootFrame.getContentPane().getComponent(0);
                panel.fireChange(JChemPaintEditorPanel.JCP_CLOSING);
            }
            if (2 != (clear = ((JChemPaintPanel)((JFrame)e.getSource()).getContentPane().getComponents()[0]).showWarning())) {
                for (int i = 0; i < instances.size(); ++i) {
                    if (((JPanel)instances.get(i)).getParent().getParent().getParent().getParent() != (JFrame)e.getSource()) continue;
                    instances.remove(i);
                    break;
                }
                ((JFrame)e.getSource()).setVisible(false);
                ((JFrame)e.getSource()).dispose();
                if (instances.size() == 0 && !((JChemPaintPanel)rootFrame.getContentPane().getComponent(0)).isEmbedded()) {
                    System.exit(0);
                }
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popupMenu;
        JChemPaintPanel panel;
        Container parent;

        public PopupListener(JChemPaintPanel panel, JPopupMenu popupMenu) {
            this.popupMenu = popupMenu;
            this.panel = panel;
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            } else {
                JFrame frame = null;
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    if (this.panel instanceof JChemPaintViewerOnlyPanel) {
                        frame = new JFrame();
                        frame.addWindowListener(new WindowAdapter(){

                            public void windowClosing(WindowEvent e) {
                                PopupListener.this.parent.add(PopupListener.this.panel);
                                PopupListener.this.parent.repaint();
                            }
                        });
                        this.parent = this.panel.getParent();
                        this.panel.getParent().remove(this.panel);
                        frame.getContentPane().add(this.panel);
                    } else if (this.panel instanceof JChemPaintEditorPanel) {
                        DrawingPanel draw;
                        this.panel = (JChemPaintEditorPanel)this.panel;
                        ChemModel model = (ChemModel)this.panel.getChemModel();
                        frame = JChemPaintEditorPanel.getNewFrame(new JChemPaintModel((IChemModel)model));
                        JChemPaintEditorPanel newPanel = (JChemPaintEditorPanel)frame.getContentPane().getComponent(0);
                        newPanel.scaleAndCenterMolecule((IChemModel)model);
                        newPanel.addChangeListener(this.panel);
                        newPanel.setEmbedded();
                        newPanel.setIsOpenedByViewer(true);
                        JViewport viewPort = ((JScrollPane)((Container)this.panel.getComponent(0)).getComponent(0)).getViewport();
                        this.panel.drawingPanel = draw = (DrawingPanel)viewPort.getView();
                        viewPort.remove(draw);
                    }
                    frame.setVisible(true);
                    frame.pack();
                }
            }
        }
    }
}

