/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoableEdit;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.undoredo.AdjustBondOrdersEdit;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.tools.SaturationChecker;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class AdjustBondOrdersAction
extends JCPAction {
    private static final long serialVersionUID = -2930750443449102916L;

    public void actionPerformed(ActionEvent e) {
        SaturationChecker satChecker;
        HashMap<IBond, double[]> changedBonds = null;
        ChemModel model = (ChemModel)this.jcpPanel.getJChemPaintModel().getChemModel();
        logger.debug((Object)"Adjusting bondorders: ", (Object)this.type);
        if (this.type.equals("clear")) {
            try {
                satChecker = new SaturationChecker();
                changedBonds = new HashMap<IBond, double[]>();
                List containersList = ChemModelManipulator.getAllAtomContainers((IChemModel)model);
                Iterator iterator = containersList.iterator();
                while (iterator.hasNext()) {
                    IAtomContainer ac = (IAtomContainer)iterator.next();
                    IAtomContainer containerCopy = (IAtomContainer)ac.clone();
                    satChecker.unsaturate(ac.getBonds());
                    for (int j = 0; j < containerCopy.getBondCount(); ++j) {
                        IBond bondCopy = containerCopy.getBond(j);
                        IBond bond = ac.getBond(j);
                        if (bond.getOrder() == bondCopy.getOrder()) continue;
                        double[] bondOrders = new double[]{bond.getOrder(), bondCopy.getOrder()};
                        changedBonds.put(bond, bondOrders);
                    }
                }
                this.jcpPanel.getJChemPaintModel().fireChange();
            }
            catch (Exception exc) {
                String error = "Could not adjust bondorders.";
                logger.error((Object)error);
                logger.debug((Object)exc);
                JOptionPane.showMessageDialog(this.jcpPanel, error);
            }
        } else {
            try {
                satChecker = new SaturationChecker();
                changedBonds = new HashMap();
                List containersList = ChemModelManipulator.getAllAtomContainers((IChemModel)model);
                Iterator iterator = containersList.iterator();
                while (iterator.hasNext()) {
                    IAtomContainer ac = (IAtomContainer)iterator.next();
                    IAtomContainer containerCopy = (IAtomContainer)ac.clone();
                    satChecker.saturate(ac);
                    for (int j = 0; j < containerCopy.getBondCount(); ++j) {
                        IBond bondCopy = containerCopy.getBond(j);
                        IBond bond = ac.getBond(j);
                        if (bond.getOrder() == bondCopy.getOrder()) continue;
                        double[] bondOrders = new double[]{bond.getOrder(), bondCopy.getOrder()};
                        changedBonds.put(bond, bondOrders);
                    }
                }
                this.jcpPanel.getJChemPaintModel().fireChange();
            }
            catch (Exception exc) {
                String error = "Could not adjust bondorders.";
                logger.error((Object)error);
                logger.debug((Object)exc);
                JOptionPane.showMessageDialog(this.jcpPanel, error);
            }
        }
        AdjustBondOrdersEdit edit = new AdjustBondOrdersEdit(changedBonds);
        this.jcpPanel.getUndoSupport().postEdit((UndoableEdit)edit);
    }
}

