/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.undo.UndoableEdit;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.MoleculeSet;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.ReactionSet;
import org.openscience.cdk.applications.jchempaint.DrawingPanel;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.undoredo.CleanUpEdit;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.geometry.GeometryToolsInternalCoordinates;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.layout.TemplateHandler;
import org.openscience.cdk.nonotify.NoNotificationChemObjectBuilder;
import org.openscience.cdk.renderer.Renderer2DModel;

public class CleanupAction
extends JCPAction {
    private static final long serialVersionUID = -1048878006430754582L;
    private StructureDiagramGenerator diagramGenerator;

    public void actionPerformed(ActionEvent e) {
        HashMap<IAtom, Point2d[]> atomCoordsMap = new HashMap<IAtom, Point2d[]>();
        logger.info((Object)"Going to performe a clean up...");
        if (this.jcpPanel.getJChemPaintModel() != null) {
            IReactionSet reactionSet;
            JChemPaintModel jcpmodel = this.jcpPanel.getJChemPaintModel();
            if (this.diagramGenerator == null) {
                this.diagramGenerator = new StructureDiagramGenerator();
                this.diagramGenerator.setTemplateHandler(new TemplateHandler(jcpmodel.getChemModel().getBuilder()));
            }
            Renderer2DModel renderModel = jcpmodel.getRendererModel();
            double bondLength = renderModel.getBondLength() / renderModel.getScaleFactor();
            this.diagramGenerator.setBondLength(bondLength * 2.0);
            logger.debug((Object)"getting ChemModel");
            IChemModel model = jcpmodel.getChemModel();
            logger.debug((Object)"got ChemModel");
            IMoleculeSet som = model.getMoleculeSet();
            if (som != null) {
                logger.debug((Object)"no mols in som: ", som.getMoleculeCount());
                MoleculeSet newsom = new MoleculeSet();
                Iterator mols = som.molecules();
                while (mols.hasNext()) {
                    IMolecule molecule = (IMolecule)mols.next();
                    if (molecule == null || molecule.getAtomCount() <= 0) continue;
                    IMolecule cleanedMol = this.relayoutMolecule(molecule);
                    newsom.addMolecule(cleanedMol);
                    for (int j = 0; j < molecule.getAtomCount(); ++j) {
                        Point2d newCoord;
                        IAtom atom = molecule.getAtom(j);
                        IAtom newAtom = cleanedMol.getAtom(j);
                        Point2d oldCoord = jcpmodel.getRendererModel().getRenderingCoordinate(atom);
                        if (oldCoord.equals((Tuple2d)(newCoord = newAtom.getPoint2d()))) continue;
                        Point2d[] coords = new Point2d[]{newCoord, oldCoord};
                        atomCoordsMap.put(newAtom, coords);
                    }
                }
                model.setMoleculeSet((IMoleculeSet)newsom);
                CleanUpEdit edit = new CleanUpEdit(atomCoordsMap);
                this.jcpPanel.getUndoSupport().postEdit((UndoableEdit)edit);
                GeometryTools.makeRenderingCoordinates((IMoleculeSet)newsom, (HashMap)jcpmodel.getRendererModel().getRenderingCoordinates());
            }
            if ((reactionSet = model.getReactionSet()) != null) {
                ReactionSet newSet = new ReactionSet();
                Iterator reactionsIter = reactionSet.reactions();
                while (reactionsIter.hasNext()) {
                    IReaction reaction = (IReaction)reactionsIter.next();
                    Reaction newReaction = new Reaction();
                    Iterator reactants = reaction.getReactants().molecules();
                    while (reactants.hasNext()) {
                        newReaction.addReactant(this.relayoutMolecule((IMolecule)reactants.next()));
                    }
                    Iterator products = reaction.getProducts().molecules();
                    while (products.hasNext()) {
                        newReaction.addProduct(this.relayoutMolecule((IMolecule)products.next()));
                    }
                    newSet.addReaction((IReaction)newReaction);
                }
                model.setReactionSet((IReactionSet)newSet);
            }
            jcpmodel.getRendererModel().setSelectedPart((IAtomContainer)new AtomContainer());
            jcpmodel.fireChange();
            this.jcpPanel.scaleAndCenterMolecule(jcpmodel.getChemModel());
            ((DrawingPanel)this.jcpPanel.getDrawingPanel()).updateRingSetInRenderer();
            this.jcpPanel.repaint();
        }
    }

    private IMolecule relayoutMolecule(IMolecule molecule) {
        JChemPaintModel jcpmodel = this.jcpPanel.getJChemPaintModel();
        IMolecule cleanedMol = molecule;
        if (molecule != null) {
            if (molecule.getAtomCount() > 2) {
                try {
                    Point2d centre = GeometryTools.get2DCentreOfMass((IAtomContainer)molecule, (HashMap)jcpmodel.getRendererModel().getRenderingCoordinates());
                    this.diagramGenerator.setMolecule(NoNotificationChemObjectBuilder.getInstance().newMolecule((IAtomContainer)molecule));
                    this.diagramGenerator.generateExperimentalCoordinates(new Vector2d(0.0, 1.0));
                    cleanedMol = this.diagramGenerator.getMolecule();
                    GeometryToolsInternalCoordinates.translateAllPositive((IAtomContainer)cleanedMol);
                    double scaleFactor = GeometryToolsInternalCoordinates.getScaleFactor((IAtomContainer)cleanedMol, (double)jcpmodel.getRendererModel().getBondLength());
                    GeometryToolsInternalCoordinates.scaleMolecule((IAtomContainer)cleanedMol, (double)scaleFactor);
                    GeometryToolsInternalCoordinates.translate2DCentreOfMassTo((IAtomContainer)cleanedMol, (Point2d)centre);
                }
                catch (Exception exc) {
                    logger.error((Object)"Could not generate coordinates for molecule");
                    logger.debug((Object)exc);
                }
            } else {
                logger.info((Object)"Molecule with less than 2 atoms are not cleaned up");
            }
        } else {
            logger.error((Object)"Molecule is null! Cannot do layout!");
        }
        return cleanedMol;
    }
}

