/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.mechanism;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.reaction.IReactionMechanism;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.reaction.mechanism.AdductionLPMechanismTest")
public class AdductionLPMechanism
implements IReactionMechanism {
    @Override
    @TestMethod(value="testInitiate_IMoleculeSet_ArrayList_ArrayList")
    public IReaction initiate(IMoleculeSet moleculeSet, ArrayList<IAtom> atomList, ArrayList<IBond> bondList) throws CDKException {
        IMapping mapping;
        IMolecule reactantCloned;
        CDKAtomTypeMatcher atMatcher = CDKAtomTypeMatcher.getInstance(moleculeSet.getBuilder());
        if (moleculeSet.getMoleculeCount() != 2) {
            throw new CDKException("AdductionLPMechanism expects two IMolecule's");
        }
        if (atomList.size() != 2) {
            throw new CDKException("AdductionLPMechanism expects two atoms in the ArrayList");
        }
        if (bondList != null) {
            throw new CDKException("AdductionLPMechanism don't expect bonds in the ArrayList");
        }
        IMolecule molecule1 = moleculeSet.getMolecule(0);
        IMolecule molecule2 = moleculeSet.getMolecule(1);
        try {
            reactantCloned = (IMolecule)moleculeSet.getMolecule(0).clone();
            reactantCloned.add((IAtomContainer)moleculeSet.getMolecule(1).clone());
        }
        catch (CloneNotSupportedException e) {
            throw new CDKException("Could not clone IMolecule!", e);
        }
        IAtom atom1 = atomList.get(0);
        IAtom atom1C = reactantCloned.getAtom(molecule1.getAtomNumber(atom1));
        IAtom atom2 = atomList.get(1);
        IAtom atom2C = reactantCloned.getAtom(molecule1.getAtomCount() + molecule2.getAtomNumber(atom2));
        IBond newBond = molecule1.getBuilder().newInstance(IBond.class, new Object[]{atom1C, atom2C, IBond.Order.SINGLE});
        reactantCloned.addBond(newBond);
        int charge = atom1C.getFormalCharge();
        atom1C.setFormalCharge(charge + 1);
        List<ILonePair> lps = reactantCloned.getConnectedLonePairsList(atom1C);
        reactantCloned.removeLonePair(lps.get(lps.size() - 1));
        atom1C.setHybridization(null);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(reactantCloned);
        IAtomType type = atMatcher.findMatchingAtomType(reactantCloned, atom1C);
        if (type == null) {
            return null;
        }
        charge = atom2C.getFormalCharge();
        atom2C.setFormalCharge(charge - 1);
        atom2C.setHybridization(null);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(reactantCloned);
        type = atMatcher.findMatchingAtomType(reactantCloned, atom2C);
        if (type == null) {
            return null;
        }
        IReaction reaction = DefaultChemObjectBuilder.getInstance().newInstance(IReaction.class, new Object[0]);
        reaction.addReactant(molecule1);
        for (IAtom atom : molecule1.atoms()) {
            mapping = DefaultChemObjectBuilder.getInstance().newInstance(IMapping.class, atom, reactantCloned.getAtom(molecule1.getAtomNumber(atom)));
            reaction.addMapping(mapping);
        }
        for (IAtom atom : molecule2.atoms()) {
            mapping = DefaultChemObjectBuilder.getInstance().newInstance(IMapping.class, atom, reactantCloned.getAtom(molecule2.getAtomNumber(atom)));
            reaction.addMapping(mapping);
        }
        reaction.addProduct(reactantCloned);
        return reaction;
    }
}

