/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.invariant;

import java.util.List;
import java.util.Stack;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;

@TestClass(value="org.openscience.cdk.graph.invariant.ConjugatedPiSystemsDetectorTest")
public class ConjugatedPiSystemsDetector {
    @TestMethod(value="testDetectButadiene,test3Aminomethane_cation,testPiSystemWithCarbokation,testCyanoallene")
    public static IAtomContainerSet detect(IAtomContainer ac) {
        int i;
        IAtomContainerSet piSystemSet = ac.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        for (i = 0; i < ac.getAtomCount(); ++i) {
            IAtom atom = ac.getAtom(i);
            atom.setFlag(4, false);
        }
        for (i = 0; i < ac.getAtomCount(); ++i) {
            IAtom firstAtom = ac.getAtom(i);
            if (firstAtom.getFlag(4) || ConjugatedPiSystemsDetector.checkAtom(ac, firstAtom) == -1) continue;
            IAtomContainer piSystem = ac.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            Stack<IAtom> stack = new Stack<IAtom>();
            piSystem.addAtom(firstAtom);
            stack.push(firstAtom);
            firstAtom.setFlag(4, true);
            while (!stack.empty()) {
                IAtom currentAtom = (IAtom)stack.pop();
                List<IAtom> atoms = ac.getConnectedAtomsList(currentAtom);
                List<IBond> bonds = ac.getConnectedBondsList(currentAtom);
                for (int j = 0; j < atoms.size(); ++j) {
                    IAtom atom = atoms.get(j);
                    IBond bond = bonds.get(j);
                    if (!atom.getFlag(4)) {
                        int check = ConjugatedPiSystemsDetector.checkAtom(ac, atom);
                        if (check == 1) {
                            piSystem.addAtom(atom);
                            piSystem.addBond(bond);
                            continue;
                        }
                        if (check == 0) {
                            piSystem.addAtom(atom);
                            piSystem.addBond(bond);
                            stack.push(atom);
                        }
                        atom.setFlag(4, true);
                        continue;
                    }
                    if (piSystem.contains(bond) || !piSystem.contains(atom)) continue;
                    piSystem.addBond(bond);
                }
            }
            if (piSystem.getAtomCount() <= 2) continue;
            piSystemSet.addAtomContainer(piSystem);
        }
        return piSystemSet;
    }

    private static int checkAtom(IAtomContainer ac, IAtom currentAtom) {
        int check = -1;
        List<IAtom> atoms = ac.getConnectedAtomsList(currentAtom);
        List<IBond> bonds = ac.getConnectedBondsList(currentAtom);
        if (currentAtom.getFlag(5)) {
            check = 0;
        } else if (currentAtom.getFormalCharge() == 1) {
            check = 0;
        } else if (currentAtom.getFormalCharge() == -1) {
            int counterOfPi = 0;
            for (IAtom atom : atoms) {
                if (ac.getMaximumBondOrder(atom) == IBond.Order.SINGLE) continue;
                ++counterOfPi;
            }
            if (counterOfPi > 0) {
                check = 0;
            }
        } else {
            int se = ac.getConnectedSingleElectronsCount(currentAtom);
            if (se == 1) {
                check = 0;
            } else if (ac.getConnectedLonePairsCount(currentAtom) > 0) {
                check = 0;
            } else {
                int highOrderBondCount = 0;
                for (int j = 0; j < atoms.size(); ++j) {
                    IBond bond = bonds.get(j);
                    if (bond != null && bond.getOrder() == IBond.Order.SINGLE) continue;
                    ++highOrderBondCount;
                }
                if (highOrderBondCount == 1) {
                    check = 0;
                } else if (highOrderBondCount > 1) {
                    check = 1;
                }
            }
        }
        return check;
    }
}

