/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainerCreator;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.ChiIndexUtils;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.ChiPathDescriptorTest")
public class ChiPathDescriptor
implements IMolecularDescriptor {
    private SmilesParser sp;

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#chiPath", this.getClass().getName(), "$Id: 526fef981d22cebbfad0e2ef016b2e2020311a98 $", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        String[] names = new String[16];
        for (int i = 0; i < 8; ++i) {
            names[i] = "SP-" + i;
            names[i + 8] = "VP-" + i;
        }
        return names;
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer container) {
        if (this.sp == null) {
            this.sp = new SmilesParser(container.getBuilder());
        }
        IAtomContainer localAtomContainer = AtomContainerManipulator.removeHydrogens(container);
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance(container.getBuilder());
        for (IAtom atom : localAtomContainer.atoms()) {
            try {
                IAtomType type = matcher.findMatchingAtomType(localAtomContainer, atom);
                AtomTypeManipulator.configure(atom, type);
            }
            catch (Exception e) {
                return this.getDummyDescriptorValue(new CDKException("Error in atom typing: " + e.getMessage()));
            }
        }
        CDKHydrogenAdder hAdder = CDKHydrogenAdder.getInstance(container.getBuilder());
        try {
            hAdder.addImplicitHydrogens(localAtomContainer);
        }
        catch (CDKException e) {
            return this.getDummyDescriptorValue(new CDKException("Error in hydrogen addition: " + e.getMessage()));
        }
        try {
            List<List<Integer>> subgraph0 = this.order0(localAtomContainer);
            List<List<Integer>> subgraph1 = this.order1(localAtomContainer);
            List<List<Integer>> subgraph2 = this.order2(localAtomContainer);
            List<List<Integer>> subgraph3 = this.order3(localAtomContainer);
            List<List<Integer>> subgraph4 = this.order4(localAtomContainer);
            List<List<Integer>> subgraph5 = this.order5(localAtomContainer);
            List<List<Integer>> subgraph6 = this.order6(localAtomContainer);
            List<List<Integer>> subgraph7 = this.order7(localAtomContainer);
            double order0s = ChiIndexUtils.evalSimpleIndex(localAtomContainer, subgraph0);
            double order1s = ChiIndexUtils.evalSimpleIndex(localAtomContainer, subgraph1);
            double order2s = ChiIndexUtils.evalSimpleIndex(localAtomContainer, subgraph2);
            double order3s = ChiIndexUtils.evalSimpleIndex(localAtomContainer, subgraph3);
            double order4s = ChiIndexUtils.evalSimpleIndex(localAtomContainer, subgraph4);
            double order5s = ChiIndexUtils.evalSimpleIndex(localAtomContainer, subgraph5);
            double order6s = ChiIndexUtils.evalSimpleIndex(localAtomContainer, subgraph6);
            double order7s = ChiIndexUtils.evalSimpleIndex(localAtomContainer, subgraph7);
            double order0v = ChiIndexUtils.evalValenceIndex(localAtomContainer, subgraph0);
            double order1v = ChiIndexUtils.evalValenceIndex(localAtomContainer, subgraph1);
            double order2v = ChiIndexUtils.evalValenceIndex(localAtomContainer, subgraph2);
            double order3v = ChiIndexUtils.evalValenceIndex(localAtomContainer, subgraph3);
            double order4v = ChiIndexUtils.evalValenceIndex(localAtomContainer, subgraph4);
            double order5v = ChiIndexUtils.evalValenceIndex(localAtomContainer, subgraph5);
            double order6v = ChiIndexUtils.evalValenceIndex(localAtomContainer, subgraph6);
            double order7v = ChiIndexUtils.evalValenceIndex(localAtomContainer, subgraph7);
            DoubleArrayResult retval = new DoubleArrayResult();
            retval.add(order0s);
            retval.add(order1s);
            retval.add(order2s);
            retval.add(order3s);
            retval.add(order4s);
            retval.add(order5s);
            retval.add(order6s);
            retval.add(order7s);
            retval.add(order0v);
            retval.add(order1v);
            retval.add(order2v);
            retval.add(order3v);
            retval.add(order4v);
            retval.add(order5v);
            retval.add(order6v);
            retval.add(order7v);
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), retval, this.getDescriptorNames());
        }
        catch (CDKException e) {
            return this.getDummyDescriptorValue(new CDKException(e.getMessage()));
        }
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        int ndesc = this.getDescriptorNames().length;
        DoubleArrayResult results = new DoubleArrayResult(ndesc);
        for (int i = 0; i < ndesc; ++i) {
            results.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), results, this.getDescriptorNames(), e);
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(16);
    }

    private List<List<Integer>> order0(IAtomContainer atomContainer) {
        ArrayList<List<Integer>> fragments = new ArrayList<List<Integer>>();
        for (IAtom atom : atomContainer.atoms()) {
            ArrayList<Integer> tmp = new ArrayList<Integer>();
            tmp.add(atomContainer.getAtomNumber(atom));
            fragments.add(tmp);
        }
        return fragments;
    }

    private List<List<Integer>> order1(IAtomContainer atomContainer) throws CDKException {
        ArrayList<List<Integer>> fragments = new ArrayList<List<Integer>>();
        for (IBond bond : atomContainer.bonds()) {
            if (bond.getAtomCount() != 2) {
                throw new CDKException("We only consider 2 center bonds");
            }
            ArrayList<Integer> tmp = new ArrayList<Integer>();
            tmp.add(atomContainer.getAtomNumber(bond.getAtom(0)));
            tmp.add(atomContainer.getAtomNumber(bond.getAtom(1)));
            fragments.add(tmp);
        }
        return fragments;
    }

    private List<List<Integer>> order2(IAtomContainer atomContainer) {
        QueryAtomContainer[] queries = new QueryAtomContainer[1];
        try {
            queries[0] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CCC"), false);
        }
        catch (InvalidSmilesException e) {
            e.printStackTrace();
        }
        return ChiIndexUtils.getFragments(atomContainer, queries);
    }

    private List<List<Integer>> order3(IAtomContainer atomContainer) {
        QueryAtomContainer[] queries = new QueryAtomContainer[1];
        try {
            queries[0] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CCCC"), false);
        }
        catch (InvalidSmilesException e) {
            e.printStackTrace();
        }
        return ChiIndexUtils.getFragments(atomContainer, queries);
    }

    private List<List<Integer>> order4(IAtomContainer atomContainer) {
        QueryAtomContainer[] queries = new QueryAtomContainer[1];
        try {
            queries[0] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CCCCC"), false);
        }
        catch (InvalidSmilesException e) {
            e.printStackTrace();
        }
        return ChiIndexUtils.getFragments(atomContainer, queries);
    }

    private List<List<Integer>> order5(IAtomContainer atomContainer) {
        QueryAtomContainer[] queries = new QueryAtomContainer[1];
        try {
            queries[0] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CCCCCC"), false);
        }
        catch (InvalidSmilesException e) {
            e.printStackTrace();
        }
        return ChiIndexUtils.getFragments(atomContainer, queries);
    }

    private List<List<Integer>> order6(IAtomContainer atomContainer) {
        QueryAtomContainer[] queries = new QueryAtomContainer[1];
        try {
            queries[0] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CCCCCCC"), false);
        }
        catch (InvalidSmilesException e) {
            e.printStackTrace();
        }
        return ChiIndexUtils.getFragments(atomContainer, queries);
    }

    private List<List<Integer>> order7(IAtomContainer atomContainer) {
        QueryAtomContainer[] queries = new QueryAtomContainer[1];
        try {
            queries[0] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CCCCCCCC"), false);
        }
        catch (InvalidSmilesException e) {
            e.printStackTrace();
        }
        return ChiIndexUtils.getFragments(atomContainer, queries);
    }
}

