/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.EuclidRuntimeException;

public class Int2
implements EuclidConstants {
    int x;
    int y;

    public Int2() {
        this.x = 0;
        this.y = 0;
    }

    public Int2(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Int2(Int2 r) {
        this.x = r.x;
        this.y = r.y;
    }

    public void swap() {
        int t = this.x;
        this.x = this.y;
        this.y = t;
    }

    public void sortAscending() {
        if (this.x > this.y) {
            this.swap();
        }
    }

    public void sortDescending() {
        if (this.x < this.y) {
            this.swap();
        }
    }

    public void clear() {
        this.y = 0;
        this.x = 0;
    }

    public void setX(int xx) {
        this.x = xx;
    }

    public void setY(int yy) {
        this.y = yy;
    }

    public boolean isEqualTo(Int2 r) {
        return this.x == r.x && this.y == r.y;
    }

    public Int2 plus(Int2 r2) {
        return new Int2(this.x + r2.x, this.y + r2.y);
    }

    public Int2 subtract(Int2 r2) {
        return new Int2(this.x - r2.x, this.y - r2.y);
    }

    public void negative() {
        this.x = -this.x;
        this.y = -this.y;
    }

    public Int2 multiplyBy(int f) {
        return new Int2(this.x * f, this.y * f);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int elementAt(int elem) throws EuclidRuntimeException {
        if (elem == 0) {
            return this.x;
        }
        if (elem == 1) {
            return this.y;
        }
        throw new EuclidRuntimeException("bad index " + elem);
    }

    public Int2 getMidPoint(Int2 p) {
        return new Int2((this.x + p.x) / 2, (this.y + p.y) / 2);
    }

    public int dotProduct(Int2 r) {
        return this.x * r.x + this.y * r.y;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }
}

