/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import javax.vecmath.Point3d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.GravitationalIndexDescriptorTest")
public class GravitationalIndexDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(GravitationalIndexDescriptor.class);
    private static final String[] names = new String[]{"GRAV-1", "GRAV-2", "GRAV-3", "GRAVH-1", "GRAVH-2", "GRAVH-3", "GRAV-4", "GRAV-5", "GRAV-6"};

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#gravitationalIndex", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        int ndesc = this.getDescriptorNames().length;
        DoubleArrayResult results = new DoubleArrayResult(ndesc);
        for (int i = 0; i < ndesc; ++i) {
            results.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), results, this.getDescriptorNames(), e);
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer container) {
        double mass2;
        double mass1;
        if (!GeometryTools.has3DCoordinates(container)) {
            return this.getDummyDescriptorValue(new CDKException("Molecule must have 3D coordinates"));
        }
        Isotopes factory = null;
        try {
            factory = Isotopes.getInstance();
        }
        catch (Exception e) {
            logger.debug(e);
        }
        double sum = 0.0;
        for (int i = 0; i < container.getBondCount(); ++i) {
            IBond bond = container.getBond(i);
            if (bond.getAtomCount() != 2) {
                return this.getDummyDescriptorValue(new CDKException("GravitationalIndex: Only handles 2 center bonds"));
            }
            mass1 = ((IsotopeFactory)factory).getMajorIsotope(bond.getAtom(0).getSymbol()).getMassNumber().intValue();
            mass2 = ((IsotopeFactory)factory).getMajorIsotope(bond.getAtom(1).getSymbol()).getMassNumber().intValue();
            Point3d p1 = bond.getAtom(0).getPoint3d();
            Point3d p2 = bond.getAtom(1).getPoint3d();
            double x1 = p1.x;
            double y1 = p1.y;
            double z1 = p1.z;
            double x2 = p2.x;
            double y2 = p2.y;
            double z2 = p2.z;
            double dist = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
            sum += mass1 * mass2 / dist;
        }
        double heavysum = 0.0;
        for (int i = 0; i < container.getBondCount(); ++i) {
            IBond b = container.getBond(i);
            if (b.getAtomCount() != 2) {
                return this.getDummyDescriptorValue(new CDKException("GravitationalIndex: Only handles 2 center bonds"));
            }
            if (b.getAtom(0).getSymbol().equals("H") || b.getAtom(1).getSymbol().equals("H")) continue;
            mass1 = ((IsotopeFactory)factory).getMajorIsotope(b.getAtom(0).getSymbol()).getMassNumber().intValue();
            mass2 = ((IsotopeFactory)factory).getMajorIsotope(b.getAtom(1).getSymbol()).getMassNumber().intValue();
            Point3d point0 = b.getAtom(0).getPoint3d();
            Point3d point1 = b.getAtom(1).getPoint3d();
            double x1 = point0.x;
            double y1 = point0.y;
            double z1 = point0.z;
            double x2 = point1.x;
            double y2 = point1.y;
            double z2 = point1.z;
            double dist = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
            heavysum += mass1 * mass2 / dist;
        }
        ArrayList<Integer> x = new ArrayList<Integer>();
        for (int i = 0; i < container.getAtomCount(); ++i) {
            if (container.getAtom(i).getSymbol().equals("H")) continue;
            x.add(i);
        }
        int npair = x.size() * (x.size() - 1) / 2;
        pair[] p = new pair[npair];
        for (int i = 0; i < npair; ++i) {
            p[i] = new pair();
        }
        int pcount = 0;
        for (int i = 0; i < x.size() - 1; ++i) {
            for (int j = i + 1; j < x.size(); ++j) {
                boolean present = false;
                int a = (Integer)x.get(i);
                int b = (Integer)x.get(j);
                for (int k = 0; k < pcount; ++k) {
                    if ((p[k].x != a || p[k].y != b) && (p[k].y != a || p[k].x != b)) continue;
                    present = true;
                }
                if (present) continue;
                p[pcount].x = a;
                p[pcount].y = b;
                ++pcount;
            }
        }
        double allheavysum = 0.0;
        for (pair aP : p) {
            int atomNumber1 = aP.x;
            int atomNumber2 = aP.y;
            mass1 = ((IsotopeFactory)factory).getMajorIsotope(container.getAtom(atomNumber1).getSymbol()).getMassNumber().intValue();
            mass2 = ((IsotopeFactory)factory).getMajorIsotope(container.getAtom(atomNumber2).getSymbol()).getMassNumber().intValue();
            double x1 = container.getAtom((int)atomNumber1).getPoint3d().x;
            double y1 = container.getAtom((int)atomNumber1).getPoint3d().y;
            double z1 = container.getAtom((int)atomNumber1).getPoint3d().z;
            double x2 = container.getAtom((int)atomNumber2).getPoint3d().x;
            double y2 = container.getAtom((int)atomNumber2).getPoint3d().y;
            double z2 = container.getAtom((int)atomNumber2).getPoint3d().z;
            double dist = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
            allheavysum += mass1 * mass2 / dist;
        }
        DoubleArrayResult retval = new DoubleArrayResult(9);
        retval.add(heavysum);
        retval.add(Math.sqrt(heavysum));
        retval.add(Math.pow(heavysum, 0.3333333333333333));
        retval.add(sum);
        retval.add(Math.sqrt(sum));
        retval.add(Math.pow(sum, 0.3333333333333333));
        retval.add(allheavysum);
        retval.add(Math.sqrt(allheavysum));
        retval.add(Math.pow(allheavysum, 0.3333333333333333));
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), retval, this.getDescriptorNames());
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(9);
    }

    private class pair {
        int x = 0;
        int y = 0;
    }
}

