/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.formula.rules.IRule;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.formula.MolecularFormulaCheckerTest")
public class MolecularFormulaChecker {
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(MolecularFormulaChecker.class);
    private List<IRule> rules;

    public MolecularFormulaChecker(List<IRule> rules) {
        this.rules = rules;
    }

    @TestMethod(value="testGetRules")
    public List<IRule> getRules() {
        return this.rules;
    }

    @TestMethod(value="testIsValidSum_IMolecularFormula")
    public Double isValidSum(IMolecularFormula formula) {
        double result = 1.0;
        IMolecularFormula formulaWith = this.isValid(formula);
        Map properties = formulaWith.getProperties();
        Iterator<IRule> iterRules = this.rules.iterator();
        while (iterRules.hasNext()) {
            result *= ((Double)properties.get(iterRules.next().getClass())).doubleValue();
        }
        return result;
    }

    @TestMethod(value="testIsValid_IMolecularFormula")
    public IMolecularFormula isValid(IMolecularFormula formula) {
        this.logger.info((Object)"Generating the validity of the molecular formula");
        if (formula.getIsotopeCount() == 0) {
            this.logger.error((Object)"Proposed molecular formula has not elements");
            return formula;
        }
        Iterator<IRule> iterRules = this.rules.iterator();
        try {
            while (iterRules.hasNext()) {
                IRule rule = iterRules.next();
                double result = rule.validate(formula);
                formula.setProperty(rule.getClass(), (Object)result);
            }
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
        return formula;
    }
}

