/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.Serializer;
import nu.xom.Text;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.AbstractTool;
import org.xmlcml.cml.base.AttributeFactory;
import org.xmlcml.cml.base.CMLAttribute;
import org.xmlcml.cml.base.CMLBuilder;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLLog;
import org.xmlcml.cml.base.CMLNodeFactory;
import org.xmlcml.cml.base.CMLUtil;
import org.xmlcml.cml.base.HasId;
import org.xmlcml.euclid.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLElement
extends Element
implements CMLConstants,
Comparable<CMLElement>,
HasId {
    static final Logger logger = Logger.getLogger(CMLElement.class);
    static final String ID = "id";
    private Map<String, Object> propertyMap;
    private Map<String, List<CMLElement>> idMap;
    private CMLLog log = null;
    private AbstractTool tool;
    protected static CMLNodeFactory nodeFactory = CMLNodeFactory.nodeFactory;
    protected static AttributeFactory attributeFactory = AttributeFactory.attributeFactory;

    protected CMLElement() {
        super("untagged_element_beware");
        this.init();
    }

    public CMLElement(String name) {
        super(name, "http://www.xml-cml.org/schema");
        this.init();
    }

    private void init() {
    }

    public static CMLElement createCMLElement(Element element) {
        Element newElement = null;
        try {
            newElement = new CMLBuilder().parseString(CMLUtil.toXMLString(element));
        }
        catch (Exception e) {
            throw new RuntimeException("BUG", e);
        }
        if (!(newElement instanceof CMLElement)) {
            newElement = null;
        } else {
            newElement.detach();
        }
        return (CMLElement)newElement;
    }

    @Override
    public void setId(String id) {
        this.addAttribute(new Attribute(ID, id));
    }

    @Override
    public String getId() {
        return this.getAttributeValue(ID);
    }

    public CMLElement(CMLElement element) {
        this(element.getLocalName());
        this.copyAttributesFrom(element);
        this.copyChildrenFrom(element);
        this.copyNamespaces(element);
        this.copyProperties(element);
    }

    public Node copy() {
        return new CMLElement(this);
    }

    public void finishMakingElement(Element parent) {
    }

    protected void addRemove(CMLAttribute att, String value) {
        if (value == null || value.equals("")) {
            this.removeAttribute(att.getLocalName());
        } else if (att != null) {
            att.setCMLValue(value);
            super.addAttribute((Attribute)att);
        }
    }

    public void copyAttributesFrom(Element element) {
        for (int i = 0; i < element.getAttributeCount(); ++i) {
            Attribute att = element.getAttribute(i);
            Attribute newAtt = (Attribute)att.copy();
            this.addAttribute(newAtt);
        }
    }

    public void copyChildrenFrom(Element element) {
        for (int i = 0; i < element.getChildCount(); ++i) {
            Node childNode = element.getChild(i);
            Node newNode = childNode.copy();
            this.appendChild(newNode);
        }
    }

    public static void copyChildrenFromTo(Element element, Element to) {
        for (int i = 0; i < element.getChildCount(); ++i) {
            Node childNode = element.getChild(i);
            Node newNode = childNode.copy();
            to.appendChild(newNode);
        }
    }

    public void replaceChild(Node oldNode, Node newNode) {
        int pos = this.indexOf(oldNode);
        if (pos == -1) {
            throw new RuntimeException("Cannot replace non-child");
        }
        newNode.detach();
        this.removeChild(oldNode);
        this.insertChild(newNode, pos);
    }

    public void insertChild(Node newNode, int pos) {
        newNode.detach();
        super.insertChild(newNode, pos);
    }

    public void detach() {
        ParentNode parent = this.getParent();
        if (parent != null) {
            if (parent instanceof Document) {
                parent.replaceChild((Node)this, (Node)new Element("dummy"));
            } else {
                parent.removeChild((Node)this);
            }
        }
    }

    public void addNamespaceDeclaration(String prefix, String uri) {
        String namespaceURI = this.getNamespaceURI(prefix);
        if (namespaceURI == null) {
            super.addNamespaceDeclaration(prefix, uri);
        }
    }

    public void removeNamespaceDeclaration(String prefix) {
        String namespaceURI = this.getNamespaceURI(prefix);
        if (namespaceURI == null) {
            throw new RuntimeException("Cannot remove namespace prefix");
        }
    }

    public void setLocalName(String localName) {
        String lName = this.getLocalName();
        if (lName == null) {
            super.setLocalName(localName);
        }
    }

    public void setAttribute(String attName, String attValue) {
        if (ID.equals(attName)) {
            this.resetId(attValue);
        } else {
            this.addAttribute(new Attribute(attName, attValue));
        }
    }

    public void setNamespaceURI(String namespaceURI) {
        String nURI = this.getNamespaceURI();
        if (nURI == null) {
            super.setNamespaceURI(namespaceURI);
        }
    }

    public void setNamespacePrefix(String namespacePrefix) {
        String nPrefix = this.getNamespacePrefix();
        if (nPrefix == null) {
            super.setNamespacePrefix(nPrefix);
        }
    }

    public void replaceByChildren() {
        ParentNode parent = this.getParent();
        if (parent != null && parent instanceof Element) {
            int i;
            Element parentElement = (Element)parent;
            int idx = parentElement.indexOf((Node)this);
            ArrayList<Node> nodeList = new ArrayList<Node>();
            for (i = 0; i < this.getChildCount(); ++i) {
                nodeList.add(this.getChild(i));
            }
            for (i = 0; i < nodeList.size(); ++i) {
                Node node = (Node)nodeList.get(i);
                node.detach();
                parentElement.insertChild(node, idx + i);
            }
        }
        this.detach();
    }

    public void copyNamespaces(CMLElement element) {
        int n = element.getNamespaceDeclarationCount();
        for (int i = 0; i < n; ++i) {
            String namespacePrefix = element.getNamespacePrefix(i);
            String namespaceURI = element.getNamespaceURIForPrefix(namespacePrefix);
            this.addNamespaceDeclaration(namespacePrefix, namespaceURI);
        }
    }

    public void copyProperties(CMLElement element) {
        if (element.propertyMap != null) {
            this.propertyMap = new HashMap<String, Object>();
            for (String key : element.propertyMap.keySet()) {
                Object object = element.propertyMap.get(key);
                this.propertyMap.put(key, object);
            }
        }
    }

    public String getCanonicalString() {
        return CMLUtil.getCanonicalString((Node)this);
    }

    @Override
    public int compareTo(CMLElement elem) {
        String elemS;
        String thisS = CMLUtil.getCanonicalString((Node)this);
        int i = thisS.compareTo(elemS = CMLUtil.getCanonicalString((Node)elem));
        return i == 0 ? 0 : (i < 0 ? -1 : 1);
    }

    protected void unknownAttributeName(String name) {
        throw new RuntimeException("Unknown CML attribute " + name + " on " + this.getLocalName());
    }

    protected String getCMLAttributeValue(String name) {
        CMLAttribute a = (CMLAttribute)this.getAttribute(name);
        return a == null ? null : (String)a.getCMLValue();
    }

    protected CMLElement getOrCreateChild(String name) throws RuntimeException {
        CMLElement element = (CMLElement)this.getFirstChildElement(name, "http://www.xml-cml.org/schema");
        if (element == null) {
            try {
                element = (CMLElement)Class.forName("org.xmlcml.cml.element.CML" + name.substring(0, 1) + name.substring(1)).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("" + e);
            }
        }
        return element;
    }

    public Nodes cmlQuery(String query) {
        return super.query(query, CMLConstants.CML_XPATH);
    }

    public Nodes removeChildren() {
        int length = this.getChildCount();
        Nodes result = new Nodes();
        for (int i = 0; i < length; ++i) {
            Node child = this.getChild(0);
            this.removeChild(child);
            result.append(child);
        }
        return result;
    }

    public void removeAttribute(String attName) {
        Attribute att = this.getAttribute(attName);
        if (att != null) {
            this.removeAttribute(att);
        }
    }

    public static void copyAttributesFromTo(Element from, Element to) {
        for (int i = 0; i < from.getAttributeCount(); ++i) {
            Attribute att = from.getAttribute(i);
            CMLAttribute newAtt = att instanceof CMLAttribute ? new CMLAttribute((CMLAttribute)att) : new Attribute(att);
            to.addAttribute((Attribute)newAtt);
        }
    }

    public static void deleteAttribute(Element element, String attName) {
        Attribute att = element.getAttribute(attName);
        if (att != null) {
            att.detach();
        }
    }

    public void debug(String message) {
        Util.println((String)("<<<<<<" + message + "<<<<<<"));
        this.debug();
        Util.println((String)(">>>>>>" + message + ">>>>>>"));
    }

    public void debug() {
        try {
            this.debug(System.out, 2);
        }
        catch (IOException e) {
            Util.BUG((Exception)e);
        }
    }

    public void debug(int indent) {
        try {
            this.debug(System.out, indent);
        }
        catch (IOException e) {
            Util.BUG((Exception)e);
        }
    }

    public void debug(OutputStream os, int indent) throws IOException {
        Document document;
        ParentNode parent = this.getParent();
        if (parent instanceof Document) {
            document = (Document)parent;
        } else {
            CMLElement copyElem = new CMLElement(this);
            document = new Document((Element)copyElem);
        }
        Serializer serializer = new Serializer(os);
        serializer.setIndent(indent);
        serializer.write(document);
    }

    public void setProperty(String property, Object value) {
        if (property != null) {
            if (this.propertyMap == null) {
                this.propertyMap = new HashMap<String, Object>();
            }
            if (value == null) {
                this.propertyMap.remove(property);
            } else {
                this.propertyMap.put(property, value);
            }
        }
    }

    public Object getProperty(String property) {
        return property == null || this.propertyMap == null ? null : this.propertyMap.get(property);
    }

    public List<String> getPropertyNames() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.propertyMap != null) {
            for (String key : this.propertyMap.keySet()) {
                list.add(key);
            }
        }
        return list;
    }

    public List<CMLElement> getChildCMLElements() {
        ArrayList<CMLElement> elementList = new ArrayList<CMLElement>();
        Elements elements = this.getChildElements();
        for (int i = 0; i < elements.size(); ++i) {
            if (!(elements.get(i) instanceof CMLElement)) continue;
            elementList.add((CMLElement)elements.get(i));
        }
        return elementList;
    }

    public Elements getChildCMLElements(String name) {
        return this.getChildElements(name, "http://www.xml-cml.org/schema");
    }

    public Element getFirstCMLChild(String name) {
        return this.getFirstChildElement(name, "http://www.xml-cml.org/schema");
    }

    public Element getChildCMLElement(String name, int i) {
        Elements childElements = this.getChildCMLElements(name);
        return i < 0 || i >= childElements.size() ? null : childElements.get(i);
    }

    public int getCMLChildCount(String name) {
        Elements childElements = this.getChildCMLElements(name);
        return childElements.size();
    }

    public String getAttributeGroupName(String attributeName) {
        return null;
    }

    public List<CMLElement> getDescendantCMLElementsById(String id) {
        ArrayList<CMLElement> elementList = new ArrayList<CMLElement>();
        if (id != null) {
            List<CMLElement> childElements = this.getChildCMLElements();
            for (CMLElement e : childElements) {
                if (!id.equals(e.getAttribute(ID))) continue;
                elementList.add(e);
            }
        }
        return elementList;
    }

    public List<CMLElement> getElements(String cmlQueryString) {
        Nodes nodes = this.query(cmlQueryString, CMLConstants.CML_XPATH);
        ArrayList<CMLElement> cmlElements = new ArrayList<CMLElement>();
        for (int i = 0; i < nodes.size(); ++i) {
            if (!(nodes.get(i) instanceof CMLElement)) continue;
            cmlElements.add((CMLElement)nodes.get(i));
        }
        return cmlElements;
    }

    public List<CMLElement> getDescendants(String elementName, boolean nested) {
        return this.getDescendants(elementName, null, nested);
    }

    public List<CMLElement> getDescendants(String elementName, String attributeName, boolean nested) {
        ArrayList<CMLElement> elementList = new ArrayList<CMLElement>();
        boolean found = false;
        if (!(elementName != null && !this.getLocalName().equals(elementName) || attributeName != null && this.getAttributeValue(attributeName) == null)) {
            elementList.add(this);
            found = true;
        }
        if (!found || nested) {
            List<CMLElement> childElements = this.getChildCMLElements();
            for (CMLElement e : childElements) {
                List<CMLElement> descendants = e.getDescendants(elementName, attributeName, nested);
                elementList.addAll(descendants);
            }
        }
        return elementList;
    }

    public List<CMLElement> getDescendants() {
        ArrayList<CMLElement> elementList = new ArrayList<CMLElement>();
        elementList.add(this);
        List<CMLElement> childElements = this.getChildCMLElements();
        for (CMLElement e : childElements) {
            List<CMLElement> descendants = e.getDescendants();
            elementList.addAll(descendants);
        }
        return elementList;
    }

    public String getStringContent() {
        Node child = this.getChildCount() == 0 ? null : this.getChild(0);
        String s = child == null || !(child instanceof Text) ? null : child.getValue();
        return s;
    }

    public void setStringContent(String value) {
        Text newText = new Text(value);
        if (this.getChildCount() == 0) {
            this.appendChild((Node)newText);
        } else {
            Node child = this.getChild(0);
            if (child instanceof Text) {
                this.replaceChild(child, (Node)newText);
            }
        }
    }

    public String getNamespaceURIForPrefix(String prefix) {
        ParentNode parent;
        String namespace = null;
        CMLElement current = this;
        while ((namespace = current.getNamespaceURI(prefix)) == null && (parent = current.getParent()) != null && !(parent instanceof Document)) {
            current = (Element)parent;
        }
        return namespace;
    }

    public String getPrefixForNamespace(String namespaceURI) {
        ParentNode parent;
        String prefix = null;
        int nCount = this.getNamespaceDeclarationCount();
        for (int i = 0; i < nCount; ++i) {
            String px = this.getNamespacePrefix(i);
            if (!namespaceURI.equals(this.getNamespaceURI(px))) continue;
            prefix = px;
            break;
        }
        if (prefix == null && (parent = this.getParent()) != null && parent instanceof CMLElement) {
            prefix = ((CMLElement)parent).getPrefixForNamespace(namespaceURI);
        }
        return prefix;
    }

    public CMLElement getOldestCMLAncestor() {
        ParentNode parent;
        CMLElement current = this;
        while ((parent = current.getParent()) != null && parent instanceof CMLElement) {
            current = (CMLElement)parent;
        }
        return current;
    }

    public List<CMLElement> getElementsById(String id, boolean refresh) {
        List<CMLElement> elemList;
        if (this.idMap == null || refresh) {
            this.idMap = new HashMap<String, List<CMLElement>>();
            this.addIds(this);
        }
        if ((elemList = this.idMap.get(id)) == null) {
            elemList = new ArrayList<CMLElement>();
        }
        return elemList;
    }

    void addIds(CMLElement elem) {
        String id = elem.getAttributeValue(ID);
        if (id != null) {
            List<CMLElement> idList = this.idMap.get(id);
            if (idList == null) {
                idList = new ArrayList<CMLElement>();
                this.idMap.put(id, idList);
            }
            if (!idList.contains(elem)) {
                idList.add(elem);
            }
        }
        List<CMLElement> childList = elem.getChildCMLElements();
        for (CMLElement child : childList) {
            this.addIds(child);
        }
    }

    public String getAncestry() {
        String s = "";
        return s;
    }

    public void writeHTML(Writer w) throws IOException {
        w.write("<span class='" + this.getLocalName() + "'>");
        w.write(this.getLocalName());
        w.write("</span>");
    }

    public void serialize(OutputStream os, int indent) throws IOException {
        Document doc = new Document((Element)((CMLElement)this.copy()));
        Serializer serializer = new Serializer(os);
        serializer.write(doc);
    }

    public void setLog(CMLLog log) {
        this.log = log;
    }

    public void addToLog(Throwable t, String message) {
        if (this.log != null) {
            this.log.add(t, message);
        }
    }

    public void setCMLXAttribute(String attName, String attValue) {
        if (attValue == null) {
            Attribute attribute = this.getAttribute(attName, "http://www.xml-cml.org/schema/cmlx");
            if (attribute != null) {
                this.removeAttribute(attribute);
            }
        } else {
            CMLElement.addCMLXAttribute(this, attName, attValue);
        }
    }

    public static void addCMLXAttribute(Element element, String attName, String attValue) {
        Attribute attribute = CMLElement.makeCMLXAttribute(attName, attValue);
        element.addAttribute(attribute);
        element.addNamespaceDeclaration("cmlx", "http://www.xml-cml.org/schema/cmlx");
    }

    public static Attribute makeCMLXAttribute(String attName, String value) {
        return new Attribute("cmlx:" + attName, "http://www.xml-cml.org/schema/cmlx", value);
    }

    public String getCMLXAttribute(String attName) {
        String value = null;
        Attribute attribute = this.getAttribute(attName, "http://www.xml-cml.org/schema/cmlx");
        if (attribute != null) {
            value = attribute.getValue();
        }
        return value;
    }

    public void appendChild(Node child) {
        child.detach();
        int childCount = this.getChildCount();
        this.insertChild(child, childCount);
    }

    public void addToLog(CMLLog.Severity severity, String message) {
        if (this.log != null) {
            this.log.add(severity, message);
        }
    }

    public void resetId(String id) {
        this.removeAttribute(ID);
        this.addAttribute(new Attribute(ID, id));
    }

    public CMLElement makeElementInContext(Element parent) {
        return new CMLElement();
    }

    public Map<String, Object> getPropertyMap() {
        return this.propertyMap;
    }

    public void setPropertyMap(Map<String, Object> propertyMap) {
        this.propertyMap = propertyMap;
    }

    public CMLLog getLog() {
        return this.log;
    }

    public AbstractTool getTool() {
        return this.tool;
    }

    public void setTool(AbstractTool tool) {
        this.tool = tool;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FormalChargeControl {
        DEFAULT(0),
        NO_DEFAULT(Integer.MIN_VALUE);

        int defalt;

        private FormalChargeControl(int def) {
            this.defalt = def;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CoordinateType {
        CARTESIAN("cartesian"),
        FRACTIONAL("fractional"),
        TWOD("twod");

        String name;

        private CoordinateType(String name) {
            this.name = name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Hybridization {
        SP3,
        SP2,
        SP,
        BENT,
        SQUARE_PLANAR,
        UNKNOWN;

    }
}

