/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.xmlcml.cml.attribute.DelimiterAttribute;
import org.xmlcml.cml.attribute.NamespaceRefAttribute;
import org.xmlcml.cml.base.CMLAttribute;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLType;
import org.xmlcml.cml.element.AbstractArray;
import org.xmlcml.cml.element.CMLScalar;
import org.xmlcml.cml.interfacex.HasArraySize;
import org.xmlcml.cml.interfacex.HasDataType;
import org.xmlcml.cml.interfacex.HasDelimiter;
import org.xmlcml.cml.interfacex.HasDictRef;
import org.xmlcml.cml.interfacex.HasUnits;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.IntArray;
import org.xmlcml.euclid.JodaDate;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLArray
extends AbstractArray
implements HasUnits,
HasArraySize,
HasDataType,
HasDictRef,
HasDelimiter {
    static Logger logger = Logger.getLogger(CMLArray.class);
    public static final String NS = "cml:array";
    private DelimiterAttribute delimiterAttribute = null;

    public CMLArray() {
        this.init();
    }

    private void init() {
    }

    public CMLArray(CMLArray old) {
        super(old);
        this.init();
    }

    @Override
    public Node copy() {
        return new CMLArray(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLArray();
    }

    @Override
    public void finishMakingElement(Element parent) {
        String dataType;
        this.delimiterAttribute = null;
        this.delimiterAttribute = (DelimiterAttribute)this.getDelimiterAttribute();
        int ll = -1;
        int size = -1;
        if (this.getSizeAttribute() != null) {
            String aa = super.getAttributeValue("size");
            size = Integer.parseInt(aa);
        }
        if ((dataType = this.getDataType()).equals("xsd:string")) {
            String[] ss = this.getStrings();
            ll = ss.length;
        } else if ("xsd:double".equals(CMLType.getNormalizedValue(dataType))) {
            try {
                double[] ss = this.getDoubles();
                ll = ss.length;
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Fault in XML: " + this.getXMLContent(), e);
            }
        } else if (dataType.equals("xsd:integer")) {
            try {
                int[] ss = this.getInts();
                ll = ss.length;
            }
            catch (RuntimeException e) {
                throw new RuntimeException("cannot parse as ints: " + this.getXMLContent());
            }
        } else if (dataType.equals("dataTypeType")) {
            String[] ss = this.getStrings();
            ll = ss.length;
        } else if (dataType.equals("namespaceRefType")) {
            String[] ss = this.getStrings();
            ll = ss.length;
        } else if (dataType.equals("unitsType")) {
            String[] ss = this.getStrings();
            ll = ss.length;
        } else {
            throw new RuntimeException("array does  not support dataType: " + dataType);
        }
        if (size != -1 && ll != size) {
            throw new RuntimeException("Size attribute: " + size + " incompatible with content: " + ll);
        }
        if (size != -1) {
            this.resetSize(ll);
        } else {
            this.removeAttribute("size");
        }
    }

    public void ensureDelimiterAttribute(DelimiterAttribute.Action action) {
        if (action.equals((Object)DelimiterAttribute.Action.RESET)) {
            this.delimiterAttribute = null;
        }
        this.delimiterAttribute = (DelimiterAttribute)this.getDelimiterAttribute();
        if (this.delimiterAttribute == null) {
            this.delimiterAttribute = new DelimiterAttribute(" ");
            super.setDelimiter(" ");
        }
    }

    @Override
    public CMLAttribute getDelimiterAttribute() {
        this.delimiterAttribute = (DelimiterAttribute)super.getDelimiterAttribute();
        return this.delimiterAttribute;
    }

    public CMLArray(String[] array) throws RuntimeException {
        this.setArray(array);
    }

    public CMLArray(String[] array, String delimiter) throws RuntimeException {
        this.setDelimiter(delimiter);
        this.setArray(array);
    }

    public CMLArray(RealArray array) {
        this.setArray(array.getArray());
    }

    public CMLArray(double[] array) {
        this.setArray(array);
    }

    public CMLArray(boolean[] array) {
        this.setArray(array);
    }

    public CMLArray(double[] array, String delimiter) throws RuntimeException {
        this.setDelimiter(delimiter);
        this.setArray(array);
    }

    public CMLArray(DateTime[] array) {
        this.setArray(array);
    }

    public CMLArray(int[] array) {
        this.setArray(array);
    }

    public CMLArray(int[] array, String delimiter) {
        this.setDelimiter(delimiter);
        this.setArray(array);
    }

    public CMLArray(String dataType) {
        this();
        this.resetDataType(dataType);
    }

    public static CMLArray createArray(List<CMLScalar> scalarList) {
        CMLArray array = null;
        if (scalarList != null && scalarList.size() > 0) {
            CMLScalar scalar = scalarList.get(0);
            if (scalar == null) {
                throw new RuntimeException("Null scalar in list: " + scalarList.size());
            }
            array = CMLArray.createArrayWithAttributes(scalar);
        }
        for (CMLScalar scalar : scalarList) {
            array.append(scalar);
        }
        array.removeWhitespaceDelimiterAttribute();
        return array;
    }

    public static CMLArray createArrayWithAttributes(HasDataType hasDataType) {
        String units;
        String dataType = hasDataType.getDataType();
        if (dataType == null) {
            throw new RuntimeException("Null data type");
        }
        CMLArray array = new CMLArray(dataType);
        String dictRef = hasDataType.getDictRef();
        if (dictRef != null) {
            array.setDictRef(dictRef);
        }
        if ((units = ((HasUnits)((Object)hasDataType)).getUnits()) != null) {
            array.setUnits(units);
        }
        array.removeWhitespaceDelimiterAttribute();
        return array;
    }

    public CMLArray createEmptyArray(CMLScalar scalar) {
        CMLArray array = null;
        if (scalar != null && scalar.getDataType() != null) {
            array = new CMLArray(scalar.getDataType());
        }
        array.removeWhitespaceDelimiterAttribute();
        return array;
    }

    public CMLArray createSubArray(int start, int end) throws IllegalArgumentException {
        int size = this.getSize();
        if (start < 0 || end >= size || end < start) {
            throw new IllegalArgumentException("bad array slice indexes " + start + "/" + end + " in " + size);
        }
        String dataType = this.getDataType();
        AbstractArray subArray = null;
        if (dataType == null || dataType.equals("xsd:string")) {
            String[] sout = new String[end - start + 1];
            String[] ss = this.getStrings();
            for (int i = start; i <= end; ++i) {
                sout[i - start] = ss[i];
            }
            String delimiter = this.getDelimiter();
            subArray = delimiter == null ? new CMLArray(sout) : new CMLArray(sout, delimiter);
        } else if (dataType.equals("xsd:double")) {
            RealArray realArray = new RealArray(this.getDoubles());
            subArray = new CMLArray(realArray.getSubArray(start, end));
        } else if (dataType.equals("xsd:integer")) {
            IntArray intArray = new IntArray(this.getInts());
            subArray = new CMLArray(intArray.getSubArray(start, end).getArray());
        }
        String dictRef = this.getDictRef();
        if (dictRef != null) {
            subArray.setDictRef(dictRef);
        }
        return subArray;
    }

    @Override
    public int getArraySize() {
        return this.getSize();
    }

    public Object getPrimitiveArray() {
        Object[] primitiveArray = null;
        primitiveArray = "xsd:double".equals(this.getDataType()) ? this.getDoubles() : ("xsd:boolean".equals(this.getDataType()) ? (Object[])this.getBooleans() : ("xsd:date".equals(this.getDataType()) ? (Object[])this.getDates() : ("xsd:integer".equals(this.getDataType()) ? (Object[])this.getInts() : ("xsd:string".equals(this.getDataType()) ? (Object[])this.getStrings() : (Object[])this.getStrings()))));
        return primitiveArray;
    }

    public String[] getStrings() {
        String[] ss = null;
        if (this.getDataType().equals("xsd:string")) {
            ss = this.getSplitContent();
        }
        return ss;
    }

    private String[] getSplitContent() throws RuntimeException {
        String[] ss = new String[]{};
        String content = this.getXMLContent();
        if (content != null) {
            content = content.trim();
            this.ensureDelimiterAttribute(DelimiterAttribute.Action.PRESERVE);
            ss = this.delimiterAttribute.getSplitContent(content);
            int size = -1;
            if (this.getSizeAttribute() == null || ss.length != (size = super.getSize())) {
                // empty if block
            }
        }
        this.removeWhitespaceDelimiterAttribute();
        return ss;
    }

    public boolean[] getBooleans() throws RuntimeException {
        boolean[] dd = null;
        String dataType = this.getDataType();
        if (dataType != null && "xsd:boolean".equals(CMLType.getNormalizedValue(dataType))) {
            String[] ss = this.getSplitContent();
            dd = new boolean[ss.length];
            for (int i = 0; i < dd.length; ++i) {
                dd[i] = new Boolean(ss[i]);
            }
        }
        return dd;
    }

    @Override
    public double[] getDoubles() throws RuntimeException {
        double[] dd = null;
        String dataType = this.getDataType();
        if (dataType != null && "xsd:double".equals(CMLType.getNormalizedValue(dataType))) {
            String[] ss = this.getSplitContent();
            dd = new double[ss.length];
            for (int i = 0; i < dd.length; ++i) {
                try {
                    dd[i] = Util.parseFlexibleDouble((String)ss[i]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("Bad double :" + ss[i] + " at position: " + i, nfe);
                }
                catch (ParseException e) {
                    throw new RuntimeException("Bad double : " + ss[i] + "at position " + i, e);
                }
            }
        }
        return dd;
    }

    public DateTime[] getDates() throws RuntimeException {
        DateTime[] dd = null;
        String dataType = this.getDataType();
        if (dataType != null && "xsd:date".equals(CMLType.getNormalizedValue(dataType))) {
            String[] ss = this.getSplitContent();
            dd = new DateTime[ss.length];
            for (int i = 0; i < dd.length; ++i) {
                dd[i] = JodaDate.parseDate((String)ss[i]);
            }
        }
        return dd;
    }

    @Override
    public int[] getInts() throws RuntimeException {
        int[] ii = null;
        String dataType = this.getDataType();
        if ("xsd:integer".equals(dataType)) {
            String[] ss = this.getSplitContent();
            ii = new int[ss.length];
            for (int i = 0; i < ii.length; ++i) {
                try {
                    ii[i] = new Integer(ss[i]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("Bad int (" + ss[i] + ") at position: " + i);
                }
            }
        }
        return ii;
    }

    public CMLScalar getElementAt(int i) {
        CMLScalar scalar = null;
        if (i >= 0 && i < this.getSize()) {
            String dataType = this.getDataType();
            if (dataType == null) {
                dataType = "xsd:string";
            }
            if (dataType.equals("xsd:string")) {
                String s = this.getStrings()[i];
                scalar = new CMLScalar(s);
            } else if (dataType.equals("xsd:boolean")) {
                Boolean b = this.getBooleans()[i];
                scalar = new CMLScalar(b);
            } else if (dataType.equals("xsd:date")) {
                DateTime d = this.getDates()[i];
                scalar = new CMLScalar(d);
            } else if (dataType.equals("xsd:double")) {
                Double d = this.getDoubles()[i];
                scalar = new CMLScalar(d);
            } else if (dataType.equals("xsd:integer")) {
                Integer ii = this.getInts()[i];
                scalar = new CMLScalar(ii);
            }
            CMLArray.copyAttributesFromTo(this, scalar);
        }
        return scalar;
    }

    public static void copyAttributesFromTo(Element from, Element to) {
        CMLArray.copyAttributeTo(from, to, "constantToSI");
        CMLArray.copyAttributeTo(from, to, "convention");
        CMLArray.copyAttributeTo(from, to, "dictRef");
        CMLArray.copyAttributeTo(from, to, "id");
        CMLArray.copyAttributeTo(from, to, "multiplierToSI");
        CMLArray.copyAttributeTo(from, to, "title");
        CMLArray.copyAttributeTo(from, to, "units");
    }

    private static void copyAttributeTo(Element from, Element to, String attName) {
        String attVal = from.getAttributeValue(attName);
        if (attVal != null) {
            to.addAttribute(new Attribute(attName, attVal));
        }
    }

    @Override
    public List<String> getStringValues() {
        ArrayList<String> values;
        block4: {
            double[] doubles;
            String dataType;
            block5: {
                int[] ints;
                block3: {
                    String[] strings;
                    values = new ArrayList<String>();
                    dataType = this.getDataType();
                    if (dataType != null && !dataType.equals("xsd:string")) break block3;
                    for (String s : strings = this.getStrings()) {
                        values.add(s);
                    }
                    break block4;
                }
                if (!"xsd:integer".equals(dataType)) break block5;
                for (int i : ints = this.getInts()) {
                    values.add("" + i);
                }
                break block4;
            }
            if (!"xsd:double".equals(dataType)) break block4;
            for (double d : doubles = this.getDoubles()) {
                values.add("" + d);
            }
        }
        return values;
    }

    public void setArray(String[] array) throws RuntimeException {
        this.resetDataType("xsd:string");
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.PRESERVE);
        for (String s : array) {
            this.delimiterAttribute.checkDelimiter(s);
        }
        this.setXMLContent(this.delimiterAttribute.getDelimitedXMLContent(array));
        this.resetSize(array.length);
        this.removeWhitespaceDelimiterAttribute();
    }

    private void resetDataType(String type) {
        Attribute a = this.getAttribute("dataType");
        if (a != null) {
            this.removeAttribute(a);
        }
        super.setDataType(type);
    }

    private void resetSize(int size) {
        Attribute a = this.getAttribute("size");
        if (a != null) {
            this.removeAttribute(a);
        }
        super.setSize(size);
    }

    public void setArray(DateTime[] array) {
        this.resetDataType("xsd:date");
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.PRESERVE);
        this.resetSize(array.length);
        throw new RuntimeException("dates in array not fully implemented");
    }

    public void setArray(boolean[] array) {
        this.resetDataType("xsd:boolean");
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.PRESERVE);
        this.setXMLContent(this.delimiterAttribute.getDelimitedXMLContent(array));
        this.resetSize(array.length);
        this.removeWhitespaceDelimiterAttribute();
    }

    public void setArray(double[] array) {
        this.resetDataType("xsd:double");
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.PRESERVE);
        this.setXMLContent(this.delimiterAttribute.getDelimitedXMLContent(array));
        this.resetSize(array.length);
        this.removeWhitespaceDelimiterAttribute();
    }

    public void setArray(int[] array) {
        this.resetDataType("xsd:integer");
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.PRESERVE);
        this.setXMLContent(this.delimiterAttribute.getDelimitedXMLContent(array));
        this.resetSize(array.length);
        this.removeWhitespaceDelimiterAttribute();
    }

    @Override
    public int getSize() {
        int size = -1;
        if (this.getSizeAttribute() != null) {
            size = super.getSize();
        } else {
            String[] array = this.getSplitContent();
            size = array.length;
        }
        return size;
    }

    @Override
    public String getDelimiter() {
        String delimiter = super.getDelimiter();
        if (delimiter == null) {
            this.ensureDelimiterAttribute(DelimiterAttribute.Action.RESET);
            delimiter = this.delimiterAttribute.getValue();
        }
        this.removeWhitespaceDelimiterAttribute();
        return delimiter;
    }

    @Override
    public void setDelimiter(String value) {
        String[] old = this.getSplitContent();
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.RESET);
        super.setDelimiter(value);
        this.delimiterAttribute = (DelimiterAttribute)this.getDelimiterAttribute();
        if (old.length > 0) {
            for (String s : old) {
                this.delimiterAttribute.checkDelimiter(s);
            }
            this.setXMLContent(this.delimiterAttribute.getDelimitedXMLContent(old));
        }
        this.removeWhitespaceDelimiterAttribute();
    }

    @Override
    public String getDataType() {
        String dataType = super.getDataType();
        if (dataType == null) {
            dataType = "xsd:string";
            super.setDataType(dataType);
        }
        return CMLType.getNormalizedValue(dataType);
    }

    @Override
    public void setDataType(String dType) {
        if (this.getDataTypeAttribute() != null) {
            throw new RuntimeException("Cannot reset dataType");
        }
        super.setDataType(dType);
    }

    @Override
    public void setSize(int s) {
        if (this.getSizeAttribute() != null) {
            throw new RuntimeException("user cannot reset size");
        }
        super.setSize(s);
    }

    public void checkNumericConformability(CMLArray array) {
        String thisDataType = this.getDataType();
        String arrayDataType = array.getDataType();
        if (thisDataType.equals("xsd:string") || !thisDataType.equals(arrayDataType) || this.getSize() != array.getSize()) {
            throw new RuntimeException("Unsuitable dataTypes for numeric operations / " + this.getDataType() + "/" + this.getSize() + "/" + array.getDataType() + "/" + array.getSize());
        }
    }

    public CMLArray subtract(CMLArray array) {
        this.checkNumericConformability(array);
        CMLArray resultArray = null;
        try {
            if (this.getDataType().equals("xsd:double")) {
                RealArray result = new RealArray(array.getDoubles()).subtract(new RealArray(this.getDoubles()));
                resultArray = new CMLArray(result.getArray());
            } else if (this.getDataType().equals("xsd:integer")) {
                IntArray result = new IntArray(array.getInts()).subtract(new IntArray(this.getInts()));
                resultArray = new CMLArray(result.getArray());
            }
        }
        catch (EuclidRuntimeException je) {
            throw new RuntimeException("" + (Object)((Object)je));
        }
        return resultArray;
    }

    public CMLArray plus(CMLArray array) {
        this.checkNumericConformability(array);
        CMLArray resultArray = null;
        try {
            if (this.getDataType().equals("xsd:double")) {
                RealArray result = new RealArray(this.getDoubles()).plus(new RealArray(array.getDoubles()));
                resultArray = new CMLArray(result.getArray());
            } else if (this.getDataType().equals("xsd:integer")) {
                IntArray result = new IntArray(this.getInts()).plus(new IntArray(array.getInts()));
                resultArray = new CMLArray(result.getArray());
            }
        }
        catch (EuclidRuntimeException je) {
            throw new RuntimeException("" + (Object)((Object)je));
        }
        return resultArray;
    }

    public void append(String s) throws RuntimeException {
        String dataType = this.getDataType();
        if (!"xsd:string".equals(dataType)) {
            throw new RuntimeException("Cannot add string (" + s + ") to array of: " + dataType);
        }
        this.appendXML(s, 1);
    }

    public void append(boolean b) throws RuntimeException {
        String dataType = this.getDataType();
        if (!"xsd:boolean".equals(dataType)) {
            throw new RuntimeException("Cannot add boolean to array of: " + dataType);
        }
        this.appendXML("" + b, 1);
    }

    public void append(double d) throws RuntimeException {
        String dataType = this.getDataType();
        if (!"xsd:double".equals(dataType)) {
            throw new RuntimeException("Cannot add double to array of: " + dataType);
        }
        this.appendXML(Double.toString(d), 1);
    }

    public void append(int i) throws RuntimeException {
        String dataType = this.getDataType();
        if (!"xsd:integer".equals(dataType)) {
            throw new RuntimeException("Cannot add int to array of: " + dataType);
        }
        this.appendXML("" + i, 1);
    }

    public void append(CMLArray array) {
        if (!this.getDataType().equals(array.getDataType())) {
            throw new RuntimeException("Cannot append array of different type: " + this.getDataType() + " != " + array.getDataType());
        }
        if (!this.getDelimiter().equals(array.getDelimiter())) {
            throw new RuntimeException("Cannot append array with different delimiter: " + this.getDelimiter() + " != " + array.getDelimiter());
        }
        if (this.getUnits() != null && !this.getUnits().equals(array.getUnits())) {
            throw new RuntimeException("Cannot append array with different units: " + this.getDelimiter() + " != " + array.getUnits());
        }
        String arrayString = array.getXMLContent();
        String delimiter = this.getDelimiter().trim();
        if (delimiter.length() > 0) {
            arrayString = arrayString.substring(1, arrayString.length() - 1);
        }
        this.appendXML(arrayString, array.getSize());
    }

    private void appendXML(String s, int toAdd) {
        int size = this.getSizeAttribute() == null ? 0 : this.getSize();
        this.ensureDelimiterAttribute(DelimiterAttribute.Action.PRESERVE);
        if (toAdd <= 1) {
            this.delimiterAttribute.checkDelimiter(s);
        }
        String xmlContent = this.getXMLContent();
        String delimitedContent = this.delimiterAttribute.appendXMLContent(xmlContent, s);
        this.setXMLContent(delimitedContent);
        this.resetSize(size + toAdd);
        this.removeWhitespaceDelimiterAttribute();
    }

    public void append(CMLScalar scalar) {
        if (scalar != null) {
            String dataType = this.getDataType();
            if (!dataType.equals(scalar.getDataType())) {
                throw new RuntimeException("Cannot append scalar of different type: " + dataType + " != " + scalar.getDataType());
            }
            if (this.getUnits() != null && !this.getUnits().equals(scalar.getUnits())) {
                throw new RuntimeException("Cannot append scalar with different units: " + this.getDelimiter() + " != " + scalar.getUnits());
            }
            this.append(scalar.getXMLContent(), dataType);
            this.removeWhitespaceDelimiterAttribute();
        }
    }

    private void append(String content, String dataType) {
        if ("xsd:string".equals(dataType)) {
            this.append(content);
        } else if ("xsd:boolean".equals(dataType)) {
            this.append(new Boolean(content));
        } else if ("xsd:date".equals(dataType)) {
            this.append(JodaDate.parseDate((String)content).toString());
        } else if ("xsd:double".equals(dataType)) {
            this.append(new Double(content));
        } else if ("xsd:integer".equals(dataType)) {
            this.append(new Integer(content));
        }
    }

    public void append(HasDictRef hasDictRef) {
        if (hasDictRef instanceof CMLScalar) {
            this.append((CMLScalar)hasDictRef);
        } else if (hasDictRef instanceof CMLArray) {
            this.append((CMLArray)hasDictRef);
        } else {
            throw new RuntimeException("Cannot add HasDictRef: " + ((CMLElement)((Object)hasDictRef)).getLocalName());
        }
        this.removeWhitespaceDelimiterAttribute();
    }

    @Override
    public void setUnits(String prefix, String id, String namespaceURI) {
        NamespaceRefAttribute.setUnits(this, prefix, id, namespaceURI);
    }

    public void append(DateTime d) throws RuntimeException {
        String dataType = this.getDataType();
        if (!"xsd:date".equals(dataType)) {
            throw new RuntimeException("Cannot add date to array of: " + dataType);
        }
        this.appendXML(d.toString(), 1);
    }

    @Override
    public void removeWhitespaceDelimiterAttribute() {
        CMLArray.removeWhitespaceDelimiterAttribute(this);
    }

    public static void removeWhitespaceDelimiterAttribute(HasDelimiter hasDelimiter) {
        Attribute delimiter = hasDelimiter.getDelimiterAttribute();
        if (delimiter != null && delimiter.getValue().trim().length() == 0) {
            delimiter.detach();
        }
    }
}

