/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SMILESFormat;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.io.SMILESReaderTest")
public class SMILESReader
extends DefaultChemObjectReader {
    private BufferedReader input = null;
    private SmilesParser sp = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(SMILESReader.class);

    public SMILESReader(Reader input) {
        this.input = new BufferedReader(input);
    }

    public SMILESReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public SMILESReader() {
        this(new StringReader(""));
    }

    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return SMILESFormat.getInstance();
    }

    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        if (IAtomContainerSet.class.equals(classObject)) {
            return true;
        }
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (IChemFile.class.equals(anInterface)) {
                return true;
            }
            if (!IAtomContainerSet.class.equals(anInterface)) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @TestMethod(value="testReading,testReadingSmiFile_1,testReadingSmiFile_2,testReadingSmiFile_3")
    public <T extends IChemObject> T read(T object) throws CDKException {
        this.sp = new SmilesParser(object.getBuilder());
        if (object instanceof IAtomContainerSet) {
            return (T)this.readAtomContainerSet((IAtomContainerSet)object);
        }
        if (object instanceof IChemFile) {
            IChemFile file = (IChemFile)object;
            IChemSequence sequence = (IChemSequence)file.getBuilder().newInstance(IChemSequence.class, new Object[0]);
            IChemModel chemModel = (IChemModel)file.getBuilder().newInstance(IChemModel.class, new Object[0]);
            chemModel.setMoleculeSet(this.readAtomContainerSet((IAtomContainerSet)file.getBuilder().newInstance(IAtomContainerSet.class, new Object[0])));
            sequence.addChemModel(chemModel);
            file.addChemSequence(sequence);
            return (T)file;
        }
        throw new CDKException("Only supported is reading of MoleculeSet objects.");
    }

    private IAtomContainerSet readAtomContainerSet(IAtomContainerSet som) {
        try {
            String line = this.input.readLine().trim();
            while (line != null) {
                logger.debug((Object)"Line: ", new Object[]{line});
                String[] tokens = line.split("[\\s\\t]+", 2);
                if (tokens.length > 2) {
                    throw new Exception("Malformed line");
                }
                String SMILES = tokens[0];
                String name = null;
                if (tokens.length == 2) {
                    name = tokens[1];
                }
                logger.debug((Object)"Line contains SMILES and name: ", new Object[]{SMILES, " + ", name});
                try {
                    IAtomContainer molecule = this.sp.parseSmiles(SMILES);
                    som.addAtomContainer(molecule);
                    if (name != null) {
                        molecule.setProperty((Object)"SMIdbNAME", (Object)name);
                    }
                }
                catch (Exception exception) {
                    logger.warn((Object)"This SMILES could not be parsed: ", new Object[]{SMILES});
                    logger.warn((Object)"Because of: ", new Object[]{exception.getMessage()});
                    logger.debug((Object)exception);
                }
                if (this.input.ready()) {
                    line = this.input.readLine();
                    continue;
                }
                line = null;
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Error while reading SMILES line: ", new Object[]{exception.getMessage()});
            logger.debug((Object)exception);
        }
        return som;
    }

    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }
}

