/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.templates;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.AminoAcid;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.dict.DictRef;
import org.openscience.cdk.interfaces.IAminoAcid;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.CMLReader;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AminoAcidManipulator;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;

public class AminoAcids {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(AminoAcids.class);
    private static AminoAcid[] aminoAcids = null;
    public static final String RESIDUE_NAME = "residueName";
    public static final String RESIDUE_NAME_SHORT = "residueNameShort";
    public static final String NO_ATOMS = "noOfAtoms";
    public static final String NO_BONDS = "noOfBonds";
    public static final String ID = "id";

    public static int[][] aaBondInfo() {
        if (aminoAcids == null) {
            AminoAcids.createAAs();
        }
        int[][] info = new int[153][4];
        int counter = 0;
        int total = 0;
        for (int aa = 0; aa < aminoAcids.length; ++aa) {
            AminoAcid acid = aminoAcids[aa];
            logger.debug((Object)"#bonds for ", new Object[]{acid.getProperty((Object)RESIDUE_NAME).toString(), " = " + acid.getBondCount()});
            logger.debug((Object)"total #bonds: ", new Object[]{total += acid.getBondCount()});
            for (IBond bond : acid.bonds()) {
                info[counter][0] = counter;
                info[counter][1] = acid.getAtomNumber(bond.getAtom(0));
                info[counter][2] = acid.getAtomNumber(bond.getAtom(1));
                info[counter][3] = bond.getOrder().numeric();
                ++counter;
            }
        }
        if (counter > 153) {
            logger.error((Object)"Error while creating AA info! Bond count is too large: ", new Object[]{counter});
            return null;
        }
        return info;
    }

    public static synchronized AminoAcid[] createAAs() {
        if (aminoAcids != null) {
            return aminoAcids;
        }
        aminoAcids = new AminoAcid[20];
        ChemFile list = new ChemFile();
        CMLReader reader = new CMLReader(AminoAcids.class.getClassLoader().getResourceAsStream("org/openscience/cdk/templates/data/list_aminoacids.cml"));
        try {
            list = (IChemFile)reader.read((IChemObject)list);
            List containersList = ChemFileManipulator.getAllAtomContainers((IChemFile)list);
            Iterator iterator = containersList.iterator();
            int counter = 0;
            while (iterator.hasNext()) {
                String dictRef;
                IAtomContainer ac = (IAtomContainer)iterator.next();
                logger.debug((Object)"Adding AA: ", new Object[]{ac});
                AminoAcid aminoAcid = new AminoAcid();
                Iterator atoms = ac.atoms().iterator();
                for (Object next : ac.getProperties().keySet()) {
                    logger.debug((Object)("Prop class: " + next.getClass().getName()));
                    logger.debug((Object)("Prop: " + next.toString()));
                    if (!(next instanceof DictRef)) continue;
                    dictRef = (DictRef)next;
                    if (dictRef.getType().equals("pdb:residueName")) {
                        aminoAcid.setProperty((Object)RESIDUE_NAME, (Object)ac.getProperty((Object)dictRef).toString().toUpperCase());
                        aminoAcid.setMonomerName(ac.getProperty((Object)dictRef).toString());
                        continue;
                    }
                    if (dictRef.getType().equals("pdb:oneLetterCode")) {
                        aminoAcid.setProperty((Object)RESIDUE_NAME_SHORT, ac.getProperty((Object)dictRef));
                        continue;
                    }
                    if (dictRef.getType().equals("pdb:id")) {
                        aminoAcid.setProperty((Object)ID, ac.getProperty((Object)dictRef));
                        logger.debug((Object)"Set AA ID to: ", new Object[]{ac.getProperty((Object)dictRef)});
                        continue;
                    }
                    logger.error((Object)"Cannot deal with dictRef!");
                }
                while (atoms.hasNext()) {
                    IAtom atom = (IAtom)atoms.next();
                    dictRef = (String)atom.getProperty((Object)"org.openscience.cdk.dict");
                    if (dictRef != null && dictRef.equals("pdb:nTerminus")) {
                        aminoAcid.addNTerminus(atom);
                        continue;
                    }
                    if (dictRef != null && dictRef.equals("pdb:cTerminus")) {
                        aminoAcid.addCTerminus(atom);
                        continue;
                    }
                    aminoAcid.addAtom(atom);
                }
                for (IBond bond : ac.bonds()) {
                    aminoAcid.addBond(bond);
                }
                AminoAcidManipulator.removeAcidicOxygen((IAminoAcid)aminoAcid);
                aminoAcid.setProperty((Object)NO_ATOMS, (Object)("" + aminoAcid.getAtomCount()));
                aminoAcid.setProperty((Object)NO_BONDS, (Object)("" + aminoAcid.getBondCount()));
                if (counter < aminoAcids.length) {
                    AminoAcids.aminoAcids[counter] = aminoAcid;
                } else {
                    logger.error((Object)"Could not store AminoAcid! Array too short!");
                }
                ++counter;
            }
            reader.close();
        }
        catch (Exception exception) {
            logger.error((Object)"Failed reading file: ", new Object[]{exception.getMessage()});
            logger.debug((Object)exception);
        }
        return aminoAcids;
    }

    public static Map<String, IAminoAcid> getHashMapBySingleCharCode() {
        AminoAcid[] monomers = AminoAcids.createAAs();
        HashMap<String, IAminoAcid> map = new HashMap<String, IAminoAcid>();
        for (int i = 0; i < monomers.length; ++i) {
            map.put((String)monomers[i].getProperty((Object)RESIDUE_NAME_SHORT), (IAminoAcid)monomers[i]);
        }
        return map;
    }

    public static Map<String, IAminoAcid> getHashMapByThreeLetterCode() {
        AminoAcid[] monomers = AminoAcids.createAAs();
        HashMap<String, IAminoAcid> map = new HashMap<String, IAminoAcid>();
        for (int i = 0; i < monomers.length; ++i) {
            map.put((String)monomers[i].getProperty((Object)RESIDUE_NAME), (IAminoAcid)monomers[i]);
        }
        return map;
    }

    public static String convertThreeLetterCodeToOneLetterCode(String threeLetterCode) {
        AminoAcid[] monomers = AminoAcids.createAAs();
        for (int i = 0; i < monomers.length; ++i) {
            if (!monomers[i].getProperty((Object)RESIDUE_NAME).equals(threeLetterCode)) continue;
            return (String)monomers[i].getProperty((Object)RESIDUE_NAME_SHORT);
        }
        return null;
    }

    public static String convertOneLetterCodeToThreeLetterCode(String oneLetterCode) {
        AminoAcid[] monomers = AminoAcids.createAAs();
        for (int i = 0; i < monomers.length; ++i) {
            if (!monomers[i].getProperty((Object)RESIDUE_NAME_SHORT).equals(oneLetterCode)) continue;
            return (String)monomers[i].getProperty((Object)RESIDUE_NAME);
        }
        return null;
    }
}

